
<!-- README.md is generated from README.Rmd. Please edit that file -->

# searchAnalyzeR <img src="man/figures/searchAnalyzeR.png" align="right" height="139" />

<!-- badges: start -->

[![R-CMD-check](https://github.com/chaoliu-cl/searchAnalyzeR/actions/workflows/r.yml/badge.svg)](https://github.com/chaoliu-cl/searchAnalyzeR/actions/workflows/r.yml)
[![CRAN
status](https://www.r-pkg.org/badges/version/searchAnalyzeR)](https://CRAN.R-project.org/package=searchAnalyzeR)
[![Lifecycle:
experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html#experimental)
<!-- badges: end -->

**searchAnalyzeR** provides comprehensive analytics, reporting, and
testing capabilities for systematic review search strategies. The
package helps researchers optimize their search strategies, evaluate
performance against gold standards, and generate PRISMA-compliant
reports.

## Key Features

- 🔍 **PubMed database API search integration**
- 📊 **Performance metrics calculation** (precision, recall, F1-score,
  efficiency measures)
- 🎯 **Search strategy optimization** with term effectiveness analysis
- 📈 **Rich visualizations** for search performance and temporal
  coverage
- 📋 **PRISMA-compliant reporting** with flow diagrams
- 📄 **Reproducibility tools** for transparent research
- ✅ **Benchmark validation** across multiple domains
- 🧹 **Duplicate detection** with multiple algorithms
- 📤 **Multi-format exports** (CSV, Excel, RIS, BibTeX, EndNote)

## Installation

You can install the development version of searchAnalyzeR from
[GitHub](https://github.com/) with:

``` r
# install.packages("devtools")
devtools::install_github("chaoliu-cl/searchAnalyzeR")
```

## License

This project is licensed under the GPL-3 License.

## Support

- 📧 **Email**: <chaoliu@cedarville.edu>
- 🐛 **Issues**: [GitHub
  Issues](https://github.com/chaoliu-cl/searchAnalyzeR/issues)

------------------------------------------------------------------------

**searchAnalyzeR** is designed to make systematic review search strategy
analysis more rigorous, transparent, and reproducible. Whether you’re
conducting a systematic review, meta-analysis, or methodological
research on search strategies, this package provides the tools you need
for comprehensive analysis.
