% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-utilities.R
\name{export_results}
\alias{export_results}
\title{Export Utilities for Search Analysis Results}
\usage{
export_results(
  search_results,
  file_path = NULL,
  formats = c("csv", "xlsx"),
  include_metadata = TRUE
)
}
\arguments{
\item{search_results}{Data frame with search results}

\item{file_path}{Base file path (without extension). If NULL, uses tempdir()}

\item{formats}{Vector of formats to export ("csv", "xlsx", "ris", "bibtex")}

\item{include_metadata}{Logical, whether to include metadata sheets/files}
}
\value{
Vector of created file paths
}
\description{
This file contains functions for exporting search analysis results,
reports, and data in various formats.
Export Search Results to Multiple Formats
}
\details{
This function exports search results to multiple standard formats used in
systematic reviews and reference management. Supported formats include:
\itemize{
\item \strong{CSV}: Comma-separated values for data analysis
\item \strong{Excel}: Multi-sheet workbook with metadata
\item \strong{RIS}: Reference Information Systems format for reference managers
\item \strong{BibTeX}: LaTeX bibliography format
\item \strong{EndNote}: Thomson Reuters EndNote format
}
}
\examples{
# Create sample search results
search_results <- data.frame(
  id = paste0("article_", 1:5),
  title = paste("Sample Article", 1:5),
  abstract = paste("Abstract for article", 1:5),
  source = "Sample Journal",
  date = Sys.Date(),
  stringsAsFactors = FALSE
)

# Export to multiple formats (writes to tempdir())
output_files <- export_results(search_results, formats = c("csv", "xlsx"))
print(output_files)
}
