% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{sentopicmodel}
\alias{sentopicmodel}
\title{Create a sentopic model}
\usage{
sentopicmodel(
  x,
  lexicon = NULL,
  L1 = 5,
  L2 = 3,
  L1prior = 1,
  L2prior = 5,
  beta = 0.01,
  L1cycle = 0,
  L2cycle = 0,
  reversed = TRUE
)
}
\arguments{
\item{x}{tokens object containing the texts. A coercion will be attempted if \code{x} is not a tokens.}

\item{lexicon}{a \code{quanteda} dictionary with positive and negative categories}

\item{L1}{the number of labels in the first document mixture layer}

\item{L2}{the number of labels in the second document mixture layer}

\item{L1prior}{the first layer hyperparameter of document mixtures}

\item{L2prior}{the second layer hyperparameter of document mixtures}

\item{beta}{the hyperparameter of vocabulary distribution}

\item{L1cycle}{integer specifying the cycle size between two updates of the hyperparameter L1prior}

\item{L2cycle}{integer specifying the cycle size between two updates of the hyperparameter L2prior}

\item{reversed}{indicates on which dimension should \code{lexicon} apply. When
\code{reversed=FALSE}, the lexicon is applied on the first layer of the document
mixture (as in a JST model). When \code{reversed=TRUE}, the lexicon is applied to
the second layer of the document mixture (as in a reversed-JST model).}
}
\value{
An S3 list containing the model parameter and the estimated mixture.
This object corresponds to a Gibbs sampler estimator with zero iterations.
The MCMC can be iterated using the \code{\link[=fit.sentopicmodel]{fit()}}
function.
\itemize{
\item \code{tokens} is the tokens object used to create the model
\item \code{vocabulary} contains the set of words of the corpus
\item \code{it} tracks the number of Gibbs sampling iterations
\item \code{za} is the list of topic assignment, aligned to the \code{tokens} object with
padding removed
\item \code{logLikelihood} returns the measured log-likelihood at each iteration,
with a breakdown of the likelihood into hierarchical components as
attribute
}

The \code{\link[=topWords]{topWords()}} function easily extract the most probables words of each
topic/sentiment.
}
\description{
The set of functions \code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}}, \code{\link[=rJST]{rJST()}} and
\code{\link[=sentopicmodel]{sentopicmodel()}} are all wrappers to an unified C++ routine and attempt to
replicate their corresponding model. This function is the lower level
wrapper to the C++ routine.
}
\examples{
LDA(ECB_press_conferences_tokens)
rJST(ECB_press_conferences_tokens, lexicon = LoughranMcDonald)
}
\seealso{
Fitting a model: \code{\link[=fit.sentopicmodel]{fit()}},
extracting top words: \code{\link[=topWords]{topWords()}}

Other topic models: 
\code{\link{JST}()},
\code{\link{LDA}()},
\code{\link{rJST}()}
}
\author{
Olivier Delmarcelle
}
\concept{topic models}
\keyword{internal}
