% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeR.R
\name{stdCoefs}
\alias{stdCoefs}
\title{Standardize coefficients}
\usage{
stdCoefs(object, classes=NA, std.by, std.type = "mean", p.crit = 0.05,bonferroni= FALSE)
}
\arguments{
\item{object}{A \code{\linkS4class{shapeR}} object}

\item{classes}{The classes to be grouped for standardization. Should be the same as used for the statistical tests}

\item{std.by}{The parameter to be used for standardization. Typically the length of the fish from the master.list.}

\item{std.type}{The tuning of the standardization. The standardization can be sensitive to what value all the fishes are standardized to. Possible values are:
\itemize{
\item min Standardized as the minimum value of std.by
\item mean Standardized as the mean value of std.by
\item max Standardized as the maximum value of std.by
}}

\item{p.crit}{An argument used to select the threshold critera for omitting coefficients which show interaction with fish length. If p.crit = 0.05, all coefficients which have p<0.05 are omitted. If p.crit = 0.01, only coefficients with p<0.01 are omitted.}

\item{bonferroni}{A logical parameter for performing Bonferroni for multiple testing}
}
\value{
A \code{\linkS4class{shapeR}} object with standardized shape coefficients in the slot shape.std
}
\description{
Function to standardized the wavelet and Fourier coefficients for a specific parameter such as the fish length.
For each country/population a regression coefficient is calculated as a function of fish length.
If the slope is significantly different from zero, a correction is made according to Lleonart et al 2000.
First ANCOVA is performed: variable ~ pop*length_cm, following a method by Longmore et al 2010.
If there is a significant interaction between population and length_cm, then the coefficients are not used and automatically discarded. If there is no interaction, the
coefficients are kept and standardized with regards to fish length.
}
\examples{
data(shape)
shape = stdCoefs(shape,classes="pop","length_cm")
}
\references{
Lleonart, J., Salat, J. & Torres, G.J. (2000) Removing allometric effects of body size in morphological analysis. Journal of Theoretical Biology, 205, 85-93.

Longmore, C., Fogarty, K., Neat, F., Brophy, D., Trueman, C., Milton, A. & Mariani, S. (2010) A comparison of otolith microchemistry and otolith shape analysis for the study of spatial variation in a deep-sea teleost, \emph{Coryphaenoides rupestris}. Environmental Biology of Fishes, 89, 591-605.

Reist, J.D. (1985) An Empirical-Evaluation of Several Univariate Methods That Adjust for Size Variation in Morphometric Data. Canadian Journal of Zoology-Revue Canadienne De Zoologie, 63, 1429-1439.
}
\author{
Lisa Anne Libungan
}
