% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_async_f.R
\name{select_async}
\alias{select_async}
\title{Load FAPAR data from NASA asynchronously}
\usage{
select_async(poly, date, token, async = FALSE)
}
\arguments{
\item{poly}{matrix. Coordinates of area to load}

\item{date}{character. Date of image to load in \code{YYYY-MM-DD} format.}

\item{token}{character. NASA Earthdata API token.
\href{https://urs.earthdata.nasa.gov/}{Click here}
to register and then
\href{https://wiki.earthdata.nasa.gov/pages/viewpage.action?pageId=204802786}{follow these instructions}
to obtain one. Alternatively supply your username and password to
\code{get_nasa_token()}}

\item{async}{logical. Whether the function is being run asynchronously}
}
\value{
A list containing:
\item{raster}{a SpatRaster object when \code{async} is \code{FALSE} or a PackedSpatRaster when
\code{async} is \code{TRUE}}
\item{message}{Information on the number of missing pixels}
}
\description{
Called by the select_async module in the example app and loads an
FAPAR raster for the selected area via the Earthdata API. This function is
identical to select_query but can be run asynchronously
}
\examples{
\dontrun{
 if (check_suggests(example = TRUE)) {
   poly <- matrix(c(0.5, 0.5, 1, 1, 0.5, 52, 52.5, 52.5, 52, 52), ncol = 2)
   colnames(poly) <- c("longitude", "latitude")
   date <- "2023-06-20"
   token <- get_nasa_token(username = "<username>", password = "<password>")
   ras <- select_async(poly, date, token)
 } else {
   message('reinstall with install.packages("shinyscholar", dependencies = TRUE)
   to run this example')
 }
 }
}
\author{
Simon Smart \href{mailto:simon.smart@cantab.net}{simon.smart@cantab.net}
}
