% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vt}
\alias{vt}
\title{Variate Generation for Student T Distribution}
\usage{
vt(n, df, ncp = 0, stream = NULL, antithetic = FALSE, asList = FALSE)
}
\arguments{
\item{n}{number of observations}

\item{df}{Degrees of freedom > 0}

\item{ncp}{Non-centrality parameter delta (default NULL)}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via
\code{\link[=qt]{stats::qt}};
otherwise, an integer in 1:25 indicates the \code{\link[rstream]{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qt]{stats::qt}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[rstream]{rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

Otherwise, return a list with components suitable for visualizing inversion,
specifically:
\item{u}{        A vector of generated U(0,1) variates }
\item{x}{        A vector of Student t random variates }
\item{quantile}{ Parameterized quantile function }
\item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Student T Distribution
}
\details{
Generates random variates from the Student t distribution.

Student T variates are generated by inverting uniform(0,1) variates
produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
\code{NULL}) or by \code{\link[rstream]{rstream.sample}}
(if \code{stream} is not \code{NULL}).
In either case, \code{\link[=qt]{stats::qt}} is used to
invert the uniform(0,1) variate(s).
In this way, using \code{vt} provides a monotone and synchronized
binomial variate generator, although not particularly fast.

The stream indicated must be an integer between 1 and 25 inclusive.

The t-distribution with \code{df} \eqn{= v} degrees of freedom has density

\deqn{f(x) = \frac{\Gamma((v+1)/2)}{\sqrt{v\pi} \
             \Gamma(v/2)} \ (1 + x^2/v)^{-(v+1)/2}}{%
       f(x) = \Gamm((v+1)/2) / (\sqrt(v \pi) \Gamma(v/2)) (1 + x^2/v)^-((v+1)/2)}

for all real \eqn{x}. It has mean 0 (for \eqn{v > 1}) and variance
\eqn{v/(v-2)} (for \eqn{v > 2}).

The general non-central t with parameters \eqn{(\nu, \delta)}{(v, \delta)} =
\code{(df, ncp)} is defined as the distribution of
\eqn{T_{\nu}(\delta) := (U + \delta) \ / \ \sqrt{(V/\nu)}}{%
         T(df, Del) := (U + Del) / \sqrt(V/df)}
where \eqn{U} and \eqn{V} are
independent random variables, \eqn{U \sim \mathcal{N}(0,1)}{U ~ N(0,1)}
and \eqn{V \sim \chi^2(\nu)}{V \sim \chi^2(df)}.
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qt
 vt(3, df = 3, ncp = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qt
 vt(3, 2, stream = 1)
 vt(3, 2, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qt
 vt(1, 2, stream = 1)
 vt(1, 2, stream = 2)
 vt(1, 2, stream = 1)
 vt(1, 2, stream = 2)
 vt(1, 2, stream = 1)
 vt(1, 2, stream = 2)

 set.seed(8675309)
 variates <- vt(100, 2, stream = 1)
 set.seed(8675309)
 variates <- vt(100, 2, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link[rstream]{rstream}}, \code{\link{set.seed}},
\code{\link[=runif]{stats::runif}}

\code{\link[=rt]{stats::rt}}
}
\author{
Barry Lawson (\email{blawson@bates.edu}), \cr
Larry Leemis (\email{leemis@math.wm.edu}), \cr
Vadim Kudlay (\email{vkudlay@nvidia.com})
}
\concept{random variate generation}
\keyword{distribution}
