% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUtil.R
\name{notFalsy}
\alias{notFalsy}
\alias{isFalsy}
\alias{emptyIsFalse}
\title{Judgement of falsy value}
\usage{
notFalsy(x)

isFalsy(x)

emptyIsFalse(x)
}
\arguments{
\item{x}{any R object}
}
\value{
`NA`, `""`, `NULL`, `length(0)`, `nchar == 0` and `FALSE` will return
`FALSE`, otherwise `TRUE` in `notFalsy` and the opposite in `isFalsy`
}
\description{
judge if an object is or not a falsy value. This includes:
empty value, empty string `""`, `NULL`, `NA`, length of 0 and `FALSE` itself
}
\details{
R does not have good built-in methods to judge falsy values and these kind
of values often cause errors in `if` conditions, for example
`if(NULL) 1 else 2` will cause error. So this function will be useful to
handle this kind of situations: `if(notFalsy(NULL)) 1 else 2`.

1. not working on S4 class objects.
2. `isFalsy` is the reverse of `notFalsy`: `isFalsy(x)` = !`notFalsy(x)`
3. `emptyIsFalse` is the old name for `notFalsy`

Useful for if statement. Normal empty object in if will spawn error. Wrap the
expression with `emptyIsFalse` can avoid this. See examples
}
\examples{
notFalsy(NULL)
notFalsy(NA)
notFalsy("")
try(`if(NULL) "not empty" else "empty"`) # this will generate error
if(notFalsy(NULL)) "not falsy" else "falsy" # but this will work
# Similar for `NA`, `""`, `character(0)` and more
isFalsy(NULL)
isFalsy(NA)
isFalsy("")
}
