testthat::context("Statement Join class")

testthat::test_that("Table name is deduced correctly", {
  x <- StmtJoin$new(ExprField$new("a"), ExprField$new("b"))
  testthat::expect_error(x$toString())
  x <- StmtJoin$new(ExprField$new("a", "foo"), ExprField$new("b"))
  testthat::expect_equal(x$toString(), "INNER JOIN foo ON foo.a = b")
  x <- StmtJoin$new(ExprField$new("a"), ExprField$new("b", "foo"))
  testthat::expect_equal(x$toString(), "INNER JOIN foo ON a = foo.b")
  x <- StmtJoin$new(ExprField$new("a", "hey"), ExprField$new("b", "foo"))
  testthat::expect_equal(x$toString(), "INNER JOIN hey ON hey.a = foo.b")
})

testthat::test_that("We can generate all types of joins", {
  x <- make_join("a", "foo", "b")
  testthat::expect_equal(x$toString(), "INNER JOIN foo ON foo.a = b")
  x <- make_join("a", "foo", "b", type='left')
  testthat::expect_equal(x$toString(), "LEFT OUTER JOIN foo ON foo.a = b")
  x <- make_join("a", "foo", "b", type='right')
  testthat::expect_equal(x$toString(), "RIGHT OUTER JOIN foo ON foo.a = b")
  x <- make_join("a", "foo", "b", type='full')
  testthat::expect_equal(x$toString(), "FULL OUTER JOIN foo ON foo.a = b")
})

testthat::test_that("INNER and OUTER can be omitted", {
  options(sqlq_omit_kwd = TRUE)
  x <- StmtJoin$new(ExprField$new("a", "hey"), ExprField$new("b", "foo"))
  testthat::expect_equal(x$toString(), "JOIN hey ON hey.a = foo.b")
  x <- StmtJoin$new(ExprField$new("a", "hey"), ExprField$new("b", "foo"),
                    type = "left")
  testthat::expect_equal(x$toString(), "LEFT JOIN hey ON hey.a = foo.b")
  options(sqlq_omit_kwd = FALSE)
})
