testthat::context("Insert Query class")

testthat::test_that("We can create an INSERT query with the contructor", {
  fields <- ExprListFields$new(list(ExprField$new('author'),
                                    ExprField$new('title'),
                                    ExprField$new('year')))
  row1 <- list('John Smith', 'Memories', 1999)
  values <- make_rows(list(row1))
  x <- QueryInsert$new(
      insert = StmtInsert$new(tabl = 'books', fields = fields),
      values = values
    )
  testthat::expect_equal(x$toString(),
                         paste('INSERT INTO books (author, "title", "year")',
                               "VALUES ('John Smith', 'Memories', 1999);"))

  row2 <- list('Barbara', 'My Life', 2010)
  values <- make_rows(list(row1, row2))
  x <- QueryInsert$new(
      insert = StmtInsert$new(tabl = 'books', fields = fields),
      values = values
    )
  testthat::expect_equal(x$toString(),
                         paste('INSERT INTO books (author, "title", "year")',
                               "VALUES ('John Smith', 'Memories', 1999),",
                               "('Barbara', 'My Life', 2010);"))
})

testthat::test_that("We can pass a list of list as values", {
  values <- list(list('John Smith', 'Memories', 1999),
                 list('Barbara', 'My Life', 2010))
  x <- make_insert(tabl = 'books', fields = c('author', 'title', 'year'),
                   values = values)
  testthat::expect_equal(x$toString(),
                         paste('INSERT INTO books (author, "title", "year")',
                               "VALUES ('John Smith', 'Memories', 1999),",
                               "('Barbara', 'My Life', 2010);"))
})

testthat::test_that("We can create an INSERT query with the factory", {
  x <- make_insert(tabl = 'books', fields = c('author', 'title'),
                   values = list(list('John Smith', 'Memories')))
  testthat::expect_equal(x$toString(),
                         paste('INSERT INTO books (author, "title")',
                               "VALUES ('John Smith', 'Memories');"))

  x <- make_insert(tabl = 'books', fields = c('author', 'title'),
                   values = list(list('John Smith', 'Memories'),
                                 list('Barbara', 'My Life')))
  testthat::expect_equal(x$toString(),
                         paste('INSERT INTO books (author, "title")',
                               "VALUES ('John Smith', 'Memories'),",
                               "('Barbara', 'My Life');"))
})
