% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_test.R
\name{pkg_test}
\alias{pkg_test}
\title{tests a package - runs its unit tests}
\usage{
pkg_test(
  pkgid,
  filter = NULL,
  src_pkgs = get_srcpkgs(),
  export_all = TRUE,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{pkgid}{a package name, path or package object}

\item{filter}{filter in the tests to run. cf \code{testthat::test_dir()}}

\item{src_pkgs}{a collection of source packages as a \code{srckgs} object.}

\item{export_all}{passed to \code{\link[=pkg_load]{pkg_load()}}. Enables the test functions to easily access to non-exported
functions. Caveat: If the pkg is already loaded and up-to-date with export_all=FALSE, it will not work.}

\item{quiet}{whether to be quiet/silent}

\item{...}{passed to \code{testthat::test_dir()}}
}
\value{
the results as a \code{pkg_test} object, which is an empty listL if no tests were found
}
\description{
This function will test a source package using \code{testthat},
making sure the package and its source package dependencies are up-to-date and loaded
}
\examples{
 pkg <- setup_and_get_dummy_srcpkg()
 res <- pkg_test(pkg)
 print(res)
}
