% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgs_check.R
\name{pkgs_check}
\alias{pkgs_check}
\title{checks a list of source packages}
\usage{
pkgs_check(
  pkgids = names(filter_srcpkgs(src_pkgs, filter)),
  src_pkgs = get_srcpkgs(),
  filter = NULL,
  lib = ".check",
  quiet = FALSE,
  fail_on_error = FALSE,
  ...
)
}
\arguments{
\item{pkgids}{a list of package ids (names, paths or object), or a
srcpkgs object. Also accept a singleton package object}

\item{src_pkgs}{a collection of source packages as a \code{srckgs} object.}

\item{filter}{filter out the packages to check using this pattern}

\item{lib}{directory where to install and find installed pkgs}

\item{quiet}{whether to be quiet/silent}

\item{fail_on_error}{whether to die if there is at least an error or warning in the checks}

\item{...}{passed to \code{pkg_check}}
}
\value{
the results as a \code{pkgs_test} object
}
\description{
checks a list of source packages
}
\examples{
\donttest{
 pkg <- setup_and_get_dummy_srcpkg()
 res <- pkgs_check(pkg, lib = tempfile(), fail_on_error = FALSE)
 print(res)
}
}
