% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_importers.R
\name{eem_csv}
\alias{eem_csv}
\title{Importer function for generic csv files to be used with eem_read().}
\usage{
eem_csv(file)
}
\arguments{
\item{file}{path to file passed from eem_read}
}
\value{
list with EEM data
}
\description{
This function can be used to import generic csv files containing EEM data using \code{\link[eemR]{eem_read}}. Excitation wavelengths are assumed column-wise and emission wavelengths row-wise. If your data is arranged the other way round, please use \code{\link{eem_csv2}}
}
\examples{
eems <- system.file("extdata/EEMs",package="staRdom")
eem_list <- eem_read(eems, recursive = TRUE, import_function = eem_csv)

eem_list
}
