% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_check.R
\name{eem_dilcorr}
\alias{eem_dilcorr}
\title{Create table how samples should be corrected because of dilution}
\usage{
eem_dilcorr(eem_list, abs_data, dilution, auto = FALSE, verbose = TRUE)
}
\arguments{
\item{eem_list}{eemlist}

\item{abs_data}{absorbance data as data frame}

\item{dilution}{dilution data as data frame with rownames}

\item{auto}{way how to deal with dilution is chosen automatically. See details.}

\item{verbose}{print out more information}
}
\value{
data frame
}
\description{
Due to dilution absorbance spectra need to be multiplied by the dilution factor and names of EEM samples can be adjusted to be similar to their undiluted absorbance sample. The table contains information about these two steps. Undiluted samples are suggested by finding absorbance samples match the beginning of EEM sample name (see details).
}
\details{
If you choose an automatic analysis EEMs are renamed if there is only one matching undiluted absorbance sample. Matching samples is done by comparing the beginning of the sample name (e.g. "sample3_1to10" fits "sample3").
}
\examples{
# no appropriate exmaple data available yet

}
