% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_functions.R
\name{eem_extend2largest}
\alias{eem_extend2largest}
\title{EEM sample data is extended to include all wavelengths in all samples}
\usage{
eem_extend2largest(eem_list, interpolation = FALSE, ...)
}
\arguments{
\item{eem_list}{eemlist}

\item{interpolation}{logical, whether added NAs should be interpolated}

\item{...}{arguments passed to eem_interp}
}
\value{
eemlist
}
\description{
Compared to the whole sample set, wavelengths missing in some samples are added and set NA or interpolated. This can be especially helpful, if you want to combine data measured with different wavelength intervals in a given range.
}
\examples{
\donttest{
library(dplyr)
data(eem_list)
eem_list <- eem_exclude(eem_list[1:5] \%>\%
`class<-`("eemlist"), exclude = list(em = c(318,322,326,550,438), ex = c(270,275))) \%>\%
eem_bind(eem_list[6:15] \%>\% `class<-`("eemlist"))
ggeem(eem_list)

eem_extend2largest(eem_list) \%>\%
  ggeem()
}
}
