% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{schema}
\alias{schema}
\title{Star Wars Data Schema}
\format{
A data frame with 5 rows and 4 variables:
\describe{
\item{\code{endpoint}}{The name of the SWAPI endpoint.}
\item{\code{endpoint_title}}{The title of the SWAPI endpoint.}
\item{\code{endpoint_description}}{The description of the SWAPI endpoint.}
\item{\code{properties}}{The properties of the endpoint as a nested table containing the \code{variable}, the data \code{type}, a \code{description} and the \code{format} of the property.}
}
}
\usage{
schema
}
\description{
Includes information about the schema of the tables that were sourced from
SWAPI, the \emph{Star Wars API}. Not all properties returned from the API are
columns in the data in this package: some properties were refactored into
separate tables. For example, I combined the \verb{starships/} and \verb{vehicles/}
endpoint into a single table. Both API endpoints returned a "pilots"
property, which is described in the schema as an array of people who piloted
the vehicle. The information in this property has been extracted into a
separate table called \code{pilots} in the \pkg{starwarsdb} package.
}
\references{
The Star Wars API (SWAPI).
}
\keyword{datasets}
