% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_inputs.R
\name{check_subsample_inputs}
\alias{check_subsample_inputs}
\title{Check inputs to subsample()}
\usage{
check_subsample_inputs(
  dates,
  values,
  thresh_ref,
  season_start,
  n_seasons,
  half_win,
  threshold,
  n_samples,
  freq,
  n_et_samples,
  season_weights,
  target,
  look_behind,
  look_ahead,
  look_units,
  seed
)
}
\arguments{
\item{dates}{A vector of dates of 'Date' class.}

\item{values}{Numeric values. The values must be in correspondence with \code{dates}, meaning the
\emph{i}th element in \code{values} must correspond to the \emph{i}th date in \code{dates}.}

\item{thresh_ref}{Numeric values to calculate a threshold. See 'Details'. The values must be in
correspondence with \code{dates}, meaning the \code{i}th element in \code{thresh_ref} must correspond to the
\code{i}th date in \code{dates}.}

\item{season_start}{The starting month of the first season, specified as an integer from 1 to
12. Default is 10 (October).}

\item{n_seasons}{The number of seasons in a year. Must be a factor of 12. Default is 4.}

\item{half_win}{The half width of the window of years to group \code{thresh_ref} by. See 'Details'.}

\item{threshold}{The quantile of \code{thresh_ref} above which \code{values} is sampled \code{n_et_samples}
times per year.}

\item{n_samples}{Integer of the number of below-threshold samples to be selected from \code{values}
at a frequency defined by \code{freq}.}

\item{freq}{Character of the frequency at which below-threshold samples are selected. May be
"week", "month", "quarter", or "year". See 'Details'.}

\item{n_et_samples}{Integer of the number of yearly exceeds-threshold samples to be selected
from \code{values}. See 'Details'.}

\item{season_weights}{A vector of integers of the weights to assign to seasons for random sampling of exceeds-threshold
\code{values}. Based on the rank of the seasonal average \code{thresh_ref} (from highest to lowest). Must
have length equal to the number of seasons (\code{n_seasons}). See 'Details'.}

\item{target}{One of "none" or "peaks". See 'Details'.}

\item{look_behind, look_ahead}{When \code{target} is "peaks", the number of \code{look_units} before and
after the center date to include in the sliding window to determine local maxima.}

\item{look_units}{One of "days", "weeks", or "months". The units to give \code{look_ahead} and
\code{look_behind}.}

\item{seed}{An integer which determines the state for the random number generator. Ensures
random sampling is reproducible.}
}
\value{
A TRUE/FALSE value with a "msg" attribute
}
\description{
Check inputs to subsample()
}
\keyword{internal}
