% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{str_split}
\alias{str_split}
\alias{str_split_1}
\alias{str_split_fixed}
\alias{str_split_i}
\title{Split up a string into pieces}
\usage{
str_split(string, pattern, n = Inf, simplify = FALSE)

str_split_1(string, pattern)

str_split_fixed(string, pattern, n)

str_split_i(string, pattern, i)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described in
\code{vignette("regular-expressions")}. Use \code{\link[=regex]{regex()}} for finer control of the
matching behaviour.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[=boundary]{boundary()}}. The empty string, \verb{""``, is equivalent to }boundary("character")`.}

\item{n}{Maximum number of pieces to return. Default (Inf) uses all
possible split positions.

For \code{str_split()}, this determines the maximum length of each element
of the output. For \code{str_split_fixed()}, this determines the number of
columns in the output; if an input is too short, the result will be padded
with \code{""}.}

\item{simplify}{A boolean.
\itemize{
\item \code{FALSE} (the default): returns a list of character vectors.
\item \code{TRUE}: returns a character matrix.
}}

\item{i}{Element to return. Use a negative value to count from the
right hand side.}
}
\value{
\itemize{
\item \code{str_split_1()}: a character vector.
\item \code{str_split()}: a list the same length as \code{string}/\code{pattern} containing
character vectors.
\item \code{str_split_fixed()}: a character matrix with \code{n} columns and the same
number of rows as the length of \code{string}/\code{pattern}.
\item \code{str_split_i()}: a character vector the same length as \code{string}/\code{pattern}.
}
}
\description{
This family of functions provides various ways of splitting a string up
into pieces. These two functions return a character vector:
\itemize{
\item \code{str_split_1()} takes a single string and splits it into pieces,
returning a single character vector.
\item \code{str_split_i()} splits each string in a character vector into pieces and
extracts the \code{i}th value, returning a character vector.
}

These two functions return a more complex object:
\itemize{
\item \code{str_split()} splits each string in a character vector into a varying
number of pieces, returning a list of character vectors.
\item \code{str_split_fixed()} splits each string in a character vector into a
fixed number of pieces, returning a character matrix.
}
}
\examples{
fruits <- c(
  "apples and oranges and pears and bananas",
  "pineapples and mangos and guavas"
)

str_split(fruits, " and ")
str_split(fruits, " and ", simplify = TRUE)

# If you want to split a single string, use `str_split_1`
str_split_1(fruits[[1]], " and ")

# Specify n to restrict the number of possible matches
str_split(fruits, " and ", n = 3)
str_split(fruits, " and ", n = 2)
# If n greater than number of pieces, no padding occurs
str_split(fruits, " and ", n = 5)

# Use fixed to return a character matrix
str_split_fixed(fruits, " and ", 3)
str_split_fixed(fruits, " and ", 4)

# str_split_i extracts only a single piece from a string
str_split_i(fruits, " and ", 1)
str_split_i(fruits, " and ", 4)
# use a negative number to select from the end
str_split_i(fruits, " and ", -1)
}
\seealso{
\code{\link[stringi:stri_split]{stringi::stri_split()}} for the underlying implementation.
}
