% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryByVisit.R
\name{summaryByVisit}
\alias{summaryByVisit}
\title{Creates publication-ready summary tables for continuous data grouped, by visit}
\usage{
summaryByVisit(
  data,
  vars = NULL,
  group = NULL,
  labels = NULL,
  stat_cont = "median_range",
  visit = "visit",
  order = NULL,
  visitgroup = NULL,
  digits_cont = 1,
  add_n = FALSE,
  overall = FALSE,
  as_flex_table = TRUE,
  border = TRUE,
  word_output = FALSE,
  file_name = paste0("SummaryByVisit_", format(Sys.Date(), "\%Y\%m\%d"), ".docx")
)
}
\arguments{
\item{data}{A data frame or tibble containing the data to be summarized.}

\item{vars}{Continuous variables to include in the summary table.
Need to be specified with quotes, e.g. \code{"age"} or \code{c("age", "response")}. Default to
all variables present in the data except \code{group}.}

\item{group}{A single column from \code{data}.
Need to be specified with quotes, e.g. \code{"treatment"}.
Summary statistics will be stratified according to this variable.
Default to NULL. A maximum of 3 groups are currently supported.}

\item{labels}{A list containing the labels that should be used for the
variables in the table. If NULL, labels are automatically taken from the
dataset. If no label present, the variable name is taken.}

\item{stat_cont}{Summary statistic to display for continuous variables.
Options include "median_IQR", "median_range" (default), "mean_sd",
"mean_se" and "geomMean_sd".}

\item{visit}{Name of the stratum for which summary statistics are
displayed by line. Typically, this would be \code{"visit"}.}

\item{order}{A numerical variable defining the visit order.}

\item{visitgroup}{A grouping variable for the stratum for which summary
statistics are displayed by line. Must be an ordered factor.
Typically, this would be a visit group such as e.g., baseline, follow-up etc.}

\item{digits_cont}{Digits for summary statistics and CI of continuous
variables. Default to 1.}

\item{add_n}{Logical. If TRUE, an additional column with the total
number of non-missing observations for each variable is added.}

\item{overall}{Logical. If TRUE, an additional column with the total is
added to the table. Ignored, if no groups are defined. Default to FALSE.}

\item{as_flex_table}{Logical. If TRUE (default) the gtsummary object is
converted to a flextable object. Useful when rendering to Word.}

\item{border}{Logical. If TRUE, a border will be drawn around the table. Only
available if flex_table = TRUE. Default is TRUE.}

\item{word_output}{Logical. If TRUE, the table is also saved in a word document.}

\item{file_name}{Character string.
Specify the name of the Word document containing the table.
Only used when \code{word_output} is TRUE. Needs to end with ".docx".}
}
\value{
A table of class "\code{flextable}" or \code{c("tbl_strata_nested_stack", "tbl_stack", "gtsummary")}.
Optionally returns a .docx file in the specified folder.
}
\description{
Creates publication-ready summary tables for continuous data grouped, by visit
}
