% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryTable.r
\name{summaryTable}
\alias{summaryTable}
\title{Creates publication-ready summary tables}
\usage{
summaryTable(
  data,
  vars = NULL,
  group = NULL,
  labels = NULL,
  stat_cont = "median_range",
  stat_cat = "n_percent",
  continuous_as = "continuous",
  dichotomous_as = "dichotomous",
  value = NULL,
  test = FALSE,
  test_cont = "wilcox.test",
  test_cat = "fisher.test",
  ci = FALSE,
  ci_cont = "wilcox.test",
  ci_cat = "wilson",
  conf_level = 0.95,
  digits_cont = 1,
  digits_cat = 0,
  missing = TRUE,
  missing_percent = TRUE,
  missing_text = "Missing",
  overall = FALSE,
  add_n = TRUE,
  as_flex_table = TRUE,
  border = TRUE,
  word_output = FALSE,
  file_name = paste0("SummaryTable_", format(Sys.Date(), "\%Y\%m\%d"), ".docx")
)
}
\arguments{
\item{data}{A data frame or tibble containing the data to be summarized.}

\item{vars}{Variables to include in the summary table.
Need to be specified with quotes, e.g. \code{"age"} or \code{c("age", "response")}.
Default to
all variables present in the data except \code{group}.}

\item{group}{A single column from \code{data}.
Need to be specified with quotes, e.g. \code{"treatment"}.
Summary statistics will be stratified according to this variable.
Default to NULL.}

\item{labels}{A list containing the labels that should be used for the
variables in the table. If NULL, labels are automatically taken from the
dataset. If no label present, the variable name is taken.}

\item{stat_cont}{Summary statistic to display for continuous variables. Options
include "median_IQR", "median_range" (default), "mean_sd", "mean_se" and
"geomMean_sd".}

\item{stat_cat}{Summary statistic to display for categorical variables.
Options include "n_percent" (default) and "n", and "n_N".}

\item{continuous_as}{Type for the continuous variables. Can either
be "continuous" (default) or "categorical".}

\item{dichotomous_as}{Type for the dichotomous variables. Can either be
"categorical" (default, one row per level) or "dichotomous" (only
one row with reference level (see argument \code{value}), only works if \code{missing = "FALSE"} or
\code{missing_percent = FALSE}.}

\item{value}{Specifies the reference level of a variable to display on a single row.
Default is NULL. The syntax is as follows: \code{value = list(varname ~ "level to show")}.}

\item{test}{Logical. Indicates whether p-values are displayed (TRUE)
or not (FALSE). Default to FALSE}

\item{test_cont}{Test type used to calculate the p-value
for continuous variables. Only used if \code{test = TRUE}.
Options include "t.test", "oneway.test", "kruskal.test", "wilcox.test" (default),
"paired.t.test", "paired.wilcox.test"}

\item{test_cat}{Test type used to calculated the p-value
for categorical variables.  Only used if \code{test = TRUE}.
Options include "fisher.test" (default), "chisq.test", "chisq.test.no.correct".
If NULL, the function decides itself: "chisq.test.no.correct" for categorical
variables with all expected
cell counts >=5, and "fisher.test" for categorical variables with
any expected cell count <5.}

\item{ci}{Logical. Indicates whether CI are displayed (TRUE) or
not (FALSE). Default to FALSE.}

\item{ci_cont}{Confidence interval method for continuous variables.
Only used if \code{ci = TRUE}.
Options include "t.test" and "wilcox.test" (default).}

\item{ci_cat}{Confidence interval method for categorical variables.
Options include "wilson" (default), "wilson.no.correct", "clopper.pearson",
"wald", "wald.no.correct", "agresti.coull" and "jeffreys".
If NULL, no CI will be displayed.}

\item{conf_level}{Numeric. Confidence level. Default to 0.95.}

\item{digits_cont}{Numeric. Digits for summary statistics and CI of continuous
variables. Default to 1.}

\item{digits_cat}{Numeric. Digits for summary statistics and CI of categorical
variables. Default to 0.}

\item{missing}{Logical. If TRUE (default), the missing values are shown.}

\item{missing_percent}{Indicates whether percentages for missings are shown
(TRUE, default)
or not (FALSE) for categorical variables.
If "both", then both options are displayed next to each other.}

\item{missing_text}{String indicating text shown on missing row. Default to
"Missing".}

\item{overall}{Logical. If TRUE, an additional column with the total is
added to the table. Default to FALSE.}

\item{add_n}{Logical. If TRUE (default), an additional column with the total
number of non-missing observations for each variable is added.}

\item{as_flex_table}{Logical. If TRUE (default) the gtsummary object is
converted to a flextable object. Useful when rendering to Word.}

\item{border}{Logical. If TRUE, a border will be drawn around the table. Only
available if flex_table = TRUE. Default is TRUE.}

\item{word_output}{Logical. If TRUE, the table is also saved in a word document.}

\item{file_name}{Character string.
Specify the name of the Word document containing the table.
Only used when \code{word_output} is TRUE. Needs to end with ".docx".}
}
\value{
A table of class "\code{flextable}" or \code{c("tbl_summary", "gtsummary")}.
Optionally returns a .docx file in the specified folder.
}
\description{
Creates publication-ready summary tables based on the gtsummary
package.
}
\examples{

library(survival)
data("cancer")
summaryTable(data = cancer,vars = c("inst", "time","age", "ph.ecog"),
             labels = list(inst = "Institution code",
                           time = "Time",
                           age = "Age",
                           ph.ecog = "ECOG score"))
}
