% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnorm_tailplot.R
\name{lnorm_tailplot}
\alias{lnorm_tailplot}
\title{Plot the estimated s and the corresponding confidence intervals}
\usage{
lnorm_tailplot(
  x,
  method = c("unbiased", "bootstrap", "jackknife"),
  R = 1000,
  conf.level = 0.95,
  ci.points = 101,
  xscale = "o"
)
}
\arguments{
\item{x}{a vector containing the sample data.}

\item{method}{the method used for computing the confidence intervals (options include unbiased variance estimator, jackknife, and bootstrap).}

\item{R}{the number of the bootstrap replicates.}

\item{conf.level}{the confidence level for the interval.}

\item{ci.points}{the number of thresholds used in the calculation of the confidence intervals.}

\item{xscale}{the scale of the x-axis (options include "o" = original, "l" = log scale, "b" = both).}
}
\value{
A plot showing the estimated \eqn{s(u)} versus threshold \eqn{u}, optionally on a logarithmic x-axis and including confidence intervals. Note that on the right side of the plot, one can observe the corresponding sigma values, which indicate the the standard deviation on the log-scale of the lognormal distribution associated with the estimated s-values.
}
\description{
This function produces a tail plot for the estimate \eqn{\hat{s}} over a range of thresholds for a given sample, including confidence intervals computed by one of three methods (unbiased, bootstrap or jackknife). The function also allows a choice between original and log scale.
}
\examples{
\donttest{
x = rlnorm(2e2, 2, 2)
lnorm_tailplot(x, method="unbiased", xscale="o")
}

}
\references{
Mosimann, J. E. (1970). Size allometry: size and shape variables with characterizations of the lognormal and generalized gamma distributions. Journal of the American Statistical Association, 65(330):930–945.
\doi{https://doi.org/10.2307/2284599}

Iwashita, T. & Klar, B. (2024). A gamma tail statistic and its asymptotics. Statistica Neerlandica 78:2, 264-280.
\doi{https://doi.org/10.1111/stan.12316}
}
