% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_glm.R
\name{learner_glm}
\alias{learner_glm}
\title{Construct a learner}
\usage{
learner_glm(
  formula,
  info = "glm",
  family = gaussian(),
  learner.args = NULL,
  ...
)
}
\arguments{
\item{formula}{(formula) Formula specifying response and design matrix.}

\item{info}{(character) Optional information to describe the instantiated
\link{learner} object.}

\item{family}{a description of the error distribution and link
    function to be used in the model.  For \code{glm} this can be a
    character string naming a family function, a family function or the
    result of a call to a family function.  For \code{glm.fit} only the
    third option is supported.  (See \code{\link[stats]{family}} for details of
    family functions.)}

\item{learner.args}{(list) Additional arguments to
\link[=learner]{learner$new()}.}

\item{...}{Additional arguments to \link[stats:glm]{stats::glm} or \link[MASS:glm.nb]{MASS::glm.nb}.}
}
\value{
\link{learner} object.
}
\description{
Constructs a \link{learner} class object for fitting generalized
linear models with \link[stats:glm]{stats::glm} and \link[MASS:glm.nb]{MASS::glm.nb}. Negative binomial
regression is supported with \code{family = "nb"} (or alternatively \code{family = "negbin"}).
}
\examples{
n <- 5e2
x <- rnorm(n)
w <- 50 + rexp(n, rate = 1 / 5)
y <- rpois(n, exp(2 + 0.5 * x + log(w)) * rgamma(n, 1 / 2, 1 / 2))
d0 <- data.frame(y, x, w)

lr <- learner_glm(y ~ x) # linear Gaussian model
lr$estimate(d0)
coef(lr$fit)

# negative binomial regression model with offset (using MASS::glm.nb)
lr <- learner_glm(y ~ x + offset(log(w)), family = "nb")
lr$estimate(d0)
coef(lr$fit)
lr$predict(data.frame(x = 1, w = c(1, 5))) # response scale
lr$predict(data.frame(x = 1, w = c(1, 5)), type = "link") # link scale
}
