% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bot.R
\name{sendMessage}
\alias{sendMessage}
\title{Send text messages}
\usage{
sendMessage(
  chat_id,
  text,
  parse_mode = NULL,
  disable_web_page_preview = NULL,
  disable_notification = FALSE,
  reply_to_message_id = NULL,
  reply_markup = NULL
)
}
\arguments{
\item{chat_id}{Unique identifier for the target chat or username of
the target channel.}

\item{text}{Text of the message to be sent.}

\item{parse_mode}{(Optional). Send 'Markdown' or 'HTML', if you want
Telegram apps to show bold, italic, fixed-width text or inline URLs in
your bot's message.}

\item{disable_web_page_preview}{(Optional). Disables link previews for links
in this message.}

\item{disable_notification}{(Optional). Sends the message silently. Users
will receive a notification with no sound.}

\item{reply_to_message_id}{(Optional). If the message is a reply, ID of the
original message.}

\item{reply_markup}{(Optional). A Reply Markup parameter object, it can be
either:
\itemize{
 \item{\code{\link{ReplyKeyboardMarkup}}}
 \item{\code{\link{InlineKeyboardMarkup}}}
 \item{\code{\link{ReplyKeyboardRemove}}}
 \item{\code{\link{ForceReply}}}
}}
}
\description{
Use this method to send text messages.
}
\details{
You can also use it's snake_case equivalent \code{send_message}.
}
\examples{
\dontrun{
bot <- Bot(token = bot_token("RTelegramBot"))
chat_id <- user_id("Me")

bot$sendMessage(
  chat_id = chat_id,
  text = "foo *bold* _italic_",
  parse_mode = "Markdown"
)
}
}
