% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mexTransform.R
\name{makeReferenceMarginalDistribution}
\alias{makeReferenceMarginalDistribution}
\title{Provide full marginal reference distribution for for maringal transformation}
\usage{
makeReferenceMarginalDistribution(x, r, whichNoChange = NULL)
}
\arguments{
\item{x}{output from migpd fit to the original data which does not represent at least one marginal distribution}

\item{r}{output from migpd fit to the reference data which does represent the correct marginal distribution of the variable with incomplete representation in \code{x}}

\item{whichNoChange}{Margins which are not to use the supplied reference distribution \code{r} have numeric indices, giving column numbers in original dataframe, listed in \code{whichNoChange}.}
}
\value{
An object of class "migpd".
}
\description{
This gives the option of providing a set of reference marginal distributions to use for marginal transformation if the data's own marginal distribution is not appropriate (for instance if only data for which one variable is large is available, the marginal distributions of the other variables will not be represented by the available data).  In such situations, the user can supply the full marginal information of the non-thresholded variables which are necessary to transform these variables correctly from the original margins to Gumbel/Laplace for estimation of dependence model parameters.
}
