smarmod <- migpd(summer, mqu=c(.9, .7, .7, .85, .7), penalty="none")
wmarmod <- migpd(winter, mqu=.7,  penalty="none")

mySdep1.lap <- mexDependence(smarmod,which=1, dqu=0.7)
myWdep1.lap <- mexDependence(wmarmod,which=1, dqu=0.75)
mySdep2.lap <- mexDependence(smarmod,which=2, dqu=0.8)
myWdep2.lap <- mexDependence(wmarmod,which=2, dqu=0.85)
mySdep3.lap <- mexDependence(smarmod,which=3, dqu=0.9)
myWdep3.lap <- mexDependence(wmarmod,which=3, dqu=0.7)
mySdep4.lap <- mexDependence(smarmod,which=4, dqu=0.75)
myWdep4.lap <- mexDependence(wmarmod,which=4, dqu=0.8)
mySdep5.lap <- mexDependence(smarmod,which=5, dqu=0.85)
myWdep5.lap <- mexDependence(wmarmod,which=5, dqu=0.9)

mySdep1.gum <- mexDependence(smarmod,which=1, dqu=0.7, margins = "gumbel",constrain=FALSE)
myWdep1.gum <- mexDependence(wmarmod,which=1, dqu=0.75, margins = "gumbel",constrain=FALSE)
mySdep2.gum <- mexDependence(smarmod,which=2, dqu=0.8, margins = "gumbel",constrain=FALSE)
myWdep2.gum <- mexDependence(wmarmod,which=2, dqu=0.85, margins = "gumbel",constrain=FALSE)
mySdep3.gum <- mexDependence(smarmod,which=3, dqu=0.9, margins = "gumbel",constrain=FALSE)
myWdep3.gum <- mexDependence(wmarmod,which=3, dqu=0.7, margins = "gumbel",constrain=FALSE)
mySdep4.gum <- mexDependence(smarmod,which=4, dqu=0.75, margins = "gumbel",constrain=FALSE)
myWdep4.gum <- mexDependence(wmarmod,which=4, dqu=0.8, margins = "gumbel",constrain=FALSE)
mySdep5.gum <- mexDependence(smarmod,which=5, dqu=0.85, margins = "gumbel",constrain=FALSE)
myWdep5.gum <- mexDependence(wmarmod,which=5, dqu=0.9, margins = "gumbel",constrain=FALSE)

# check plots produced for variety of thresholds and parameter combinations
par(mfcol=c(3,4),pty="m")
plot(mySdep1.gum,main=paste("Summer\nfitting quantile =",mySdep1.gum$dependence$dqu,"\nGumbel margins"))
plot(myWdep1.gum,main=paste("Winter\nfitting quantile =",myWdep1.gum$dependence$dqu,"\nGumbel margins"))
plot(mySdep2.gum,main=paste("Summer\nfitting quantile =",mySdep2.gum$dependence$dqu,"\nGumbel margins"))
plot(myWdep2.gum,main=paste("Winter\nfitting quantile =",myWdep2.gum$dependence$dqu,"\nGumbel margins"))
plot(mySdep3.gum,main=paste("Summer\nfitting quantile =",mySdep3.gum$dependence$dqu,"\nGumbel margins"))
plot(myWdep3.gum,main=paste("Winter\nfitting quantile =",myWdep3.gum$dependence$dqu,"\nGumbel margins"))
plot(mySdep4.gum,main=paste("Summer\nfitting quantile =",mySdep4.gum$dependence$dqu,"\nGumbel margins"))
plot(myWdep4.gum,main=paste("Winter\nfitting quantile =",myWdep4.gum$dependence$dqu,"\nGumbel margins"))
plot(mySdep5.gum,main=paste("Summer\nfitting quantile =",mySdep5.gum$dependence$dqu,"\nGumbel margins"))
plot(myWdep5.gum,main=paste("Winter\nfitting quantile =",myWdep5.gum$dependence$dqu,"\nGumbel margins"))

plot(mySdep1.lap,main=paste("Summer\nfitting quantile =",mySdep1.lap$dependence$dqu,"\nLaplace margins"))
plot(myWdep1.lap,main=paste("Winter\nfitting quantile =",myWdep1.lap$dependence$dqu,"\nLaplace margins"))
plot(mySdep2.lap,main=paste("Summer\nfitting quantile =",mySdep2.lap$dependence$dqu,"\nLaplace margins"))
plot(myWdep2.lap,main=paste("Winter\nfitting quantile =",myWdep2.lap$dependence$dqu,"\nLaplace margins"))
plot(mySdep3.lap,main=paste("Summer\nfitting quantile =",mySdep3.lap$dependence$dqu,"\nLaplace margins"))
plot(myWdep3.lap,main=paste("Winter\nfitting quantile =",myWdep3.lap$dependence$dqu,"\nLaplace margins"))
plot(mySdep4.lap,main=paste("Summer\nfitting quantile =",mySdep4.lap$dependence$dqu,"\nLaplace margins"))
plot(myWdep4.lap,main=paste("Winter\nfitting quantile =",myWdep4.lap$dependence$dqu,"\nLaplace margins"))
plot(mySdep5.lap,main=paste("Summer\nfitting quantile =",mySdep5.lap$dependence$dqu,"\nLaplace margins"))
plot(myWdep5.lap,main=paste("Winter\nfitting quantile =",myWdep5.lap$dependence$dqu,"\nLaplace margins"))

op <- options()
##options(show.error.messages=FALSE)
expect_error(plot.mex(smarmod), info="plot.mex: exception handle")
expect_error(plot.mex(TRUE), info="plot.mex: exception handle")
##options(op)

# check execution for 2-d data
wavesurge.fit <- migpd(wavesurge,mqu=0.8)
wavesurge.mex <- mexDependence(wavesurge.fit,dqu=0.8,which=2,margins="gumbel",constrain=FALSE)
par(mfrow=c(2,2))
res <- plot(wavesurge.mex,main="Wave surge data")
expect_equal(res, NULL, info="plot.mex:successfulexecution")
