% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-tools.R
\name{get_texfile_name}
\alias{get_texfile_name}
\title{Get the name of the tex file included within wrapper file}
\usage{
get_texfile_name(article_dir)
}
\arguments{
\item{article_dir}{path to the directory which contains tex article}
}
\value{
String name of the tex-file name
}
\description{
The wrapper file refers to an external tex file which contains
the actual document content.
}
\examples{
article_dir <- system.file("examples/article",
                 package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <- paste(your_article_folder,"article",sep="/")
texor::get_texfile_name(your_article_path)
unlink(your_article_folder,recursive = TRUE)
}
