% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_and_evaluate.R
\name{train_spec}
\alias{train_spec}
\title{Configuration for the train component of \code{train_and_evaluate}}
\usage{
train_spec(input_fn, max_steps = NULL, hooks = NULL)
}
\arguments{
\item{input_fn}{Training input function returning a tuple of:
\itemize{
\item features - \code{Tensor} or dictionary of string feature name to \code{Tensor}.
\item labels - \code{Tensor} or dictionary of \code{Tensor} with labels.
}}

\item{max_steps}{Positive number of total steps for which to train model.
If \code{NULL}, train forever. The training \code{input_fn} is not expected to
generate \code{OutOfRangeError} or \code{StopIteration} exceptions.}

\item{hooks}{List of session run hooks to run on all workers
(including chief) during training.}
}
\description{
\code{TrainSpec} determines the input data for the training, as well as the
duration. Optional hooks run at various stages of training.
}
\seealso{
Other training methods: 
\code{\link{eval_spec}()},
\code{\link{train_and_evaluate.tf_estimator}()}
}
\concept{training methods}
