% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write_gtfs}
\alias{write_gtfs}
\title{Write a tidygtfs object to a zip file}
\usage{
write_gtfs(gtfs_obj, zipfile, compression_level = 9, as_dir = FALSE)
}
\arguments{
\item{gtfs_obj}{gtfs feed (tidygtfs object)}

\item{zipfile}{path to the zip file the feed should be written to. The file is overwritten
if it already exists.}

\item{compression_level}{a number between 1 and 9, defaults to 9 (best compression).}

\item{as_dir}{if \code{TRUE}, the feed is not zipped and zipfile is used as a directory path.
The directory will be overwritten if it already exists.}
}
\value{
Invisibly returns \code{gtfs_obj}
}
\description{
Write a tidygtfs object to a zip file
}
\note{
Auxiliary tidytransit tables (e.g. \code{dates_services}) are not exported. Calls
\code{\link[gtfsio:export_gtfs]{gtfsio::export_gtfs()}} after preparing the data.
}
\examples{
\dontrun{
local_gtfs_path <- system.file("extdata", "nyc_subway.zip", package = "tidytransit")
gtfs <- read_gtfs(local_gtfs_path)

gtfs <- filter_feed_by_date(gtfs, "2018-06-30")

write_gtfs(gtfs, "feed_filtered.zip")
}
}
\seealso{
\code{\link[=read_gtfs]{read_gtfs()}}
}
