% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvedose_ph_alk.R
\name{solvedose_ph}
\alias{solvedose_ph}
\alias{solvedose_ph_df}
\title{Calculate a desired chemical dose for a target pH}
\usage{
solvedose_ph(water, target_ph, chemical)

solvedose_ph_df(
  df,
  input_water = "defined",
  output_column = "dose",
  target_ph = "use_col",
  chemical = "use_col"
)
}
\arguments{
\item{water}{Source water of class "water" created by \link{define_water}}

\item{target_ph}{The final pH to be achieved after the specified chemical is added.}

\item{chemical}{The chemical to be added. Current supported chemicals include:
acids: "hcl", "h2so4", "h3po4", "co2"; bases: "naoh", "na2co3", "nahco3", "caoh2", "mgoh2"}

\item{df}{a data frame containing a water class column, which has already been computed using
\link{define_water_df}. The df may include a column with names for each of the chemicals being dosed.}

\item{input_water}{name of the column of water class data to be used as the input. Default is "defined".}

\item{output_column}{name of the output column storing doses in mg/L. Default is "dose".}
}
\value{
\code{solvedose_ph} returns a numeric value for the required chemical dose.

\code{solvedose_ph_df} returns a data frame containing the original data frame and columns for target pH, chemical dosed, and required chemical dose.
}
\description{
Calculates the required amount of a chemical to dose based on a target pH and existing water quality.
The function takes an object of class "water", and user-specified chemical and target pH
and returns a numeric value for the required dose in mg/L.
For a single water, use \code{solvedose_ph}; to apply the model to a dataframe, use \code{solvedose_ph_df}.
For most arguments, the \verb{_df} helper
"use_col" default looks for a column of the same name in the dataframe. The argument can be specified directly in the
function instead or an unquoted column name can be provided.
}
\details{
\code{solvedose_ph} uses \code{\link[stats:uniroot]{stats::uniroot()}} on \link{chemdose_ph} to match the required dose for the requested pH target.
}
\examples{
water <- define_water(ph = 7, temp = 25, alk = 10)

# Calculate required dose of lime to reach pH 8
solvedose_ph(water, target_ph = 8, chemical = "caoh2")


example_df <- water_df \%>\%
  define_water_df() \%>\%
  solvedose_ph_df(input_water = "defined", target_ph = 8.8, chemical = "naoh")

}
\seealso{
\link{chemdose_ph}, \link{solvedose_alk}
}
