% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{parameter_sensitivity_analysis}
\alias{parameter_sensitivity_analysis}
\title{Parameter Sensitivity Analysis}
\usage{
parameter_sensitivity_analysis(
  param,
  samples,
  bins = 30,
  mae_col = "Holdout_MAE",
  threshold_pct = 5,
  min_samples = 1
)
}
\arguments{
\item{param}{The character name of the parameter to analyze.}

\item{samples}{A data frame containing parameter samples and performance metrics.}

\item{bins}{The integer number of bins to divide the parameter range into.}

\item{mae_col}{The character name of the column containing the Mean Absolute Error (MAE) values.}

\item{threshold_pct}{A numeric percentage above the minimum MAE to define an acceptable performance threshold.}

\item{min_samples}{The integer minimum number of samples required in a bin for it to be included in the analysis.}
}
\value{
An object of class "parameter_sensitivity" containing:
\item{param_values}{Vector of parameter bin midpoints}
\item{min_mae}{Vector of minimum MAE values per bin}
\item{param_name}{Name of analyzed parameter}
\item{threshold}{Threshold value (default: min. +5\%)}
\item{min_value}{Minimum MAE value across all bins}
\item{sample_counts}{Number of samples per bin}
}
\description{
Analyzes the sensitivity of the model performance (measured by MAE) to changes
in a single parameter. This function bins the parameter range to identify the
minimum MAE for each bin, helping to understand how robust the model is to
parameter choices.
}
\details{
The function performs these steps:
\enumerate{
\item Cleans the input data using Median Absolute Deviation (MAD) to remove outliers.
\item Bins the parameter values into equal-width bins.
\item Calculates the minimum MAE within each bin to create an empirical performance curve.
\item Identifies a performance threshold based on a percentage above the global minimum MAE.
\item Returns an S3 object for plotting and further analysis.
}
}
