% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{identifyImageFileNames}
\alias{identifyImageFileNames}
\title{Resolve image paths}
\usage{
identifyImageFileNames(fileName, errorIfMissing = TRUE,
  auxiliaries = c("dirs", "lut", "tags"), ...)
}
\arguments{
\item{fileName}{A character vector of image paths.}

\item{errorIfMissing}{Logical value: raise an error if no suitable files
were found?}

\item{auxiliaries}{A character vector of auxiliary file suffixes to search
for.}

\item{\dots}{Additional arguments to \code{\link{resolvePath}}.}
}
\value{
A list with the following elements, describing the identified files:
  \describe{
    \item{fileStem}{The file name without extension.}
    \item{headerFile}{The full header file name.}
    \item{imageFile}{The full image file name.}
    \item{auxiliaryFiles}{The full path to any auxiliary files.}
    \item{format}{The basic format of the files (\code{"Nifti"},
      \code{"Analyze"}, etc.).}
    \item{headerSuffix}{The file suffix associated with the header file.}
    \item{imageSuffix}{The file suffix associated with the image file.}
    \item{auxiliarySuffixes}{The file suffixes associated with any
      auxiliary files.}
  }
}
\description{
This function identifies characteristics of an image on disk, including
associated auxiliary files. Its functionality has essentially been
superseded by methods of the \code{\linkS4class{ImageFileSet}} class, but
it remains as an alternative interface to that functionality for backwards
compatibility.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\seealso{
\code{\link{imageFiles}}, \code{\link{resolvePath}}
}
\author{
Jon Clayden
}
