% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_zinb_trend.R
\encoding{UTF-8}
\name{explore_zinb_trend}
\alias{explore_zinb_trend}
\title{Explore zero-inflated models (ZIP/ZINB) for count data trends /
Analyse von Zero-Inflated-Modellen (ZIP/ZINB) fuer Zeitreihen mit Zaehldaten}
\usage{
explore_zinb_trend(
  data,
  datum_col,
  value_col,
  group_col = NULL,
  k_spline = 4,
  family = c("auto", "zip", "zinb"),
  run_vuong = FALSE,
  return_formula = FALSE,
  verbose = FALSE,
  control = NULL
)
}
\arguments{
\item{data}{Dataframe with time series count data. / Dataframe mit Zeitreihenzaehldaten.}

\item{datum_col}{Name of the time column (usually Date). / Name der Zeitspalte (normalerweise Date).}

\item{value_col}{Name of the count column (dependent variable). / Name der Zaehlspalte (abhaengige Variable).}

\item{group_col}{Optional. Name of grouping column for interaction. / Optional. Name der Gruppierungsspalte fuer Interaktion.}

\item{k_spline}{Basis dimension for spline terms (default = 4). / Basisdimension fuer Spline-Terme (Standard = 4).}

\item{family}{One of "zip", "zinb", or "auto". If "auto", selects model based on AIC. /
Einer von "zip", "zinb" oder "auto". Bei "auto" erfolgt die Auswahl basierend auf AIC.}

\item{run_vuong}{Logical. If TRUE, run Vuong test for model comparison (default = FALSE). /
Wenn TRUE, wird Vuong-Test fuer Modellvergleich durchgefuehrt (Standard = FALSE).}

\item{return_formula}{If TRUE, return model formula instead of fitting. / Wenn TRUE, wird nur die Modellformel zurueckgegeben.}

\item{verbose}{Logical. Whether to print model fitting messages. / Ob Meldungen zur Modellanpassung gedruckt werden.}

\item{control}{Optional. List for pscl::zeroinfl.control (e.g., list(maxit = 200)). Default: maxit = 100. /
Steuerparameter fuer pscl::zeroinfl.control (z.B. list(maxit = 200)). Standard: maxit = 100.}
}
\value{
A list containing model object and diagnostics. /
Eine Liste mit Modellobjekt und Diagnoseergebnissen:
\describe{
  \item{model}{The fitted zeroinfl model. / Das angepasste zeroinfl-Modell.}
  \item{summary}{Model summary (if available). / Modellzusammenfassung (wenn verfuegbar).}
  \item{plot}{Trend plot with fitted values (ggplot2). / Trendplot mit geschaetzten Werten (ggplot2).}
  \item{model_family_used}{Used model type: "ZIP" or "ZINB". / Verwendeter Modelltyp: "ZIP" oder "ZINB".}
  \item{model_selection_info}{Information about model selection logic. / Hinweise zur Modellauswahl.}
  \item{aic_comparison}{Data frame with AIC values for both models. / Data Frame mit AIC-Werten fuer beide Modelle.}
  \item{vuong_test}{Vuong test result (if computed). / Vuong-Testergebnis (falls berechnet).}
  \item{messages}{Messages from the fitting process. / Meldungen aus dem Anpassungsprozess.}
}
}
\description{
Fits zero-inflated Poisson (ZIP) or negative binomial (ZINB) models to time series count data using splines. /
Passt Zero-Inflated Poisson- oder Negativ-Binomial-Modelle mit Splines an Zeitreihen mit Zaehldaten an.
}
\details{
Supports automatic model selection based on AIC, optional Vuong test, flexible optimizer control, and visualization. /
Unterstuetzt automatische Modellauswahl basierend auf AIC, optionalen Vuong-Test, flexible Optimierungssteuerung und Visualisierung.
}
\examples{
# Simulierte Zero-Inflated Zaehldaten
set.seed(123)
df <- data.frame(
  datum = seq.Date(from = as.Date("2023-01-01"), by = "day", length.out = 100),
  value = rbinom(100, 1, 0.3) * rpois(100, lambda = 4)
)

# Automatische Auswahl zwischen ZIP und ZINB
explore_zinb_trend(df, datum_col = "datum", value_col = "value", family = "auto")

# Nur ZIP-Modell erzwingen
explore_zinb_trend(df, datum_col = "datum", value_col = "value", family = "zip", k_spline = 3)

}
\seealso{
[pscl::zeroinfl()], [pscl::vuong()], [explore_poisson_trend()]
}
