% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_item_metadata.R
\name{get_item_metadata}
\alias{get_item_metadata}
\title{Retrieve metadata for a NHS TRUD item}
\usage{
get_item_metadata(item, release_scope = c("all", "latest"))
}
\arguments{
\item{item}{An integer, the item to be downloaded. Get these from \code{\link[=trud_items]{trud_items()}}
or \code{\link[=get_subscribed_metadata]{get_subscribed_metadata()}}.}

\item{release_scope}{Which releases to retrieve metadata for. Use \code{"all"} to
get all releases, or \code{"latest"} to get only the most recent release.}
}
\value{
A list containing item metadata, including release information that
can be used with \code{\link[=download_item]{download_item()}}. Release IDs for specific downloads are
in the \code{id} field of each release.
}
\description{
Sends a request to the release list endpoint, returning a list of metadata
pertaining to the specified NHS TRUD item. Use the \code{item} numbers from
\code{\link[=trud_items]{trud_items()}} or \code{\link[=get_subscribed_metadata]{get_subscribed_metadata()}}.

\emph{\strong{Subscription Required}}

You must subscribe to TRUD items individually through the NHS TRUD website
before you can access them using \code{\link[=get_item_metadata]{get_item_metadata()}} or \code{\link[=download_item]{download_item()}}.
Simply having an API key is not sufficient. To see items you're already
subscribed to, use \code{\link[=get_subscribed_metadata]{get_subscribed_metadata()}}. To browse all available
items, use \code{\link[=trud_items]{trud_items()}}.
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true") & Sys.getenv("TRUD_API_KEY") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get metadata for Community Services Data Set pre-deadline extract XML Schema
get_item_metadata(394) |>
  # Display structure without showing sensitive API keys in URLs
  purrr::map_at("releases", \(release) purrr::map(release, names))

# Include metadata for any previous releases using `release_scope = "all"`
get_item_metadata(394, release_scope = "all") |>
  # Display structure without showing sensitive API keys in URLs
  purrr::map_at("releases", \(release) purrr::map(release, names))
\dontshow{\}) # examplesIf}
# An informative error is raised if your API key is invalid or missing
try(withr::with_envvar(c("TRUD_API_KEY" = ""), get_item_metadata(394)))
}
\seealso{
\itemize{
\item \code{\link[=trud_items]{trud_items()}} to find item numbers
\item \code{\link[=get_subscribed_metadata]{get_subscribed_metadata()}} to see items you can access
\item \code{\link[=download_item]{download_item()}} to download files using this metadata
}
}
