% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_aug_flip.R
\name{ts_aug_flip}
\alias{ts_aug_flip}
\title{Augmentation by Flip}
\usage{
ts_aug_flip()
}
\value{
A \code{ts_aug_flip} object.
}
\description{
Time series augmentation by mirroring sliding-window observations
around their mean to increase diversity and reduce overfitting.
}
\details{
This transformation preserves the window mean while flipping the
deviations, effectively generating a symmetric variant of the local pattern.
}
\examples{
# Flip augmentation around the window mean
# Load package and example dataset
library(daltoolbox)
data(tsd)

# Convert to sliding windows and preview
xw <- ts_data(tsd$y, 10)
ts_head(xw)

# Apply flip augmentation and inspect augmented windows
augment <- ts_aug_flip()
augment <- fit(augment, xw)
xa <- transform(augment, xw)
ts_head(xa)
}
\references{
\itemize{
\item Q. Wen et al. (2021). Time Series Data Augmentation for Deep Learning:
A Survey. IJCAI Workshop on Time Series.
}
}
