% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ate.R
\name{plot_ate}
\alias{plot_ate}
\title{Plot the estimated treatment effect}
\usage{
plot_ate(
  fit,
  decrease = FALSE,
  conf.int = 0.95,
  nboot = 0,
  seed = 0,
  xlab = "Time",
  ylim = c(-1, 1),
  xlim = NULL,
  plot.configs = list(ylab = NULL, main = NULL, lty = 1, lwd = 2, col = "black",
    add.null.line = TRUE, null.line.lty = 2, ci.lty = 5, ci.lwd = 1.5, ci.col =
    "darkgrey"),
  ...
)
}
\arguments{
\item{fit}{A fitted object returned by the function \code{surv.tteICE} or \code{scr.tteICE}.}

\item{decrease}{A logical variable indicating the type of curve difference to display. If \code{decrease = FALSE} (default), the function displays the difference in cumulative incidence functions (CIFs). If \code{decrease = TRUE}, the function instead displays the difference in survival functions.}

\item{conf.int}{Confidence level for the interval. If \code{conf.int = NULL}, no confidence interval is provided.}

\item{nboot}{Number of resampling in bootstrapping. By default, \code{nboot = 0}, meaning no bootstrap is performed and the standard error is computed using the explicit analytical formula.}

\item{seed}{Sets the random seed used when generating bootstrap samples.}

\item{xlab}{Label for x-axis.}

\item{ylim}{A numeric vector of length 2 giving the limits of the y-axis. Defaults to \code{ylim=c(-1, 1)}.}

\item{xlim}{A numeric vector of length 2 giving the limits of the x-axis. If \code{xlim=NULL} (default), the range is determined automatically from the data.}

\item{plot.configs}{A named \code{list} of additional plot configurations. Common entries include:

\itemize{
    \item \code{ylab}: character, label for the y-axis (default: \code{ylab=NULL}, use the default label).
    \item \code{main}: character, title for the plot (default: \code{main=NULL}, use the default label).
    \item \code{lty}: line type for effect curve (default: 1).
    \item \code{lwd}: line width for effect curve (default: 2).
    \item \code{col}: line color for effect curve (default: "black").
    \item \code{add.null.line}: logical, whether to draw a horizontal line at 0 (default: TRUE).
    \item \code{null.line.lty}: line type for horizontal line at 0 (default: 2).
    \item \code{ci.lty}: line type for confidence interval curves (default: 5).
    \item \code{ci.lwd}: line width for confidence interval curves (default: 1.5).
    \item \code{ci.col}: line color for confidence interval curves (default: "darkgrey").
  }}

\item{...}{Additional graphical arguments passed to function \code{\link{plot.default}} or function \code{\link{curve}}}
}
\value{
Plot the average treatment effect (ATE) results from a tteICE object
}
\description{
This function plots the estimated treatment effect, defined as the difference in potential cumulative incidences under treated and control groups, along with pointwise confidence intervals.
}
\examples{
## Load data and fit the model
data(bmt)
bmt = transform(bmt, d4=d2+d3)
A = as.numeric(bmt$group>1)
## Model with competing risk data
fit1 = surv.tteICE(A, bmt$t2, bmt$d4, 'composite')
## Plot asymptotic confidence intervals based on explicit formulas
plot_ate(fit1, ylim=c(-0.4,0.4))
\donttest{
## Plot bootstrap confidence intervals (may take some seconds)
plot_ate(fit1, nboot=200, ylim=c(-0.4,0.4))
}
## Model with semicompeting risk data
fit2 = scr.tteICE(A, bmt$t1, bmt$d1, bmt$t2, bmt$d2, "composite")
## Plot asymptotic confidence intervals based on explicit formulas
plot_ate(fit2, ylim=c(-0.4,0.4),
         plot.configs=list(add.null.line=FALSE))
## Plot bootstrap confidence intervals
plot_ate(fit2, nboot=200, ylim=c(-0.4,0.4),
         plot.configs=list(add.null.line=FALSE, lty=2, main=""))

}
\seealso{
\code{\link[graphics]{plot.default}},
\code{\link[graphics]{points}},
\code{\link[graphics]{curve}},
\code{\link[tteICE]{plot.tteICE}}
}
