% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependency_graph.R
\name{plot_dependency_graph}
\alias{plot_dependency_graph}
\title{Plot a field dependency graph}
\usage{
plot_dependency_graph(g, fields_df = NULL, seed = NULL)
}
\arguments{
\item{g}{An \code{igraph} directed graph from \code{\link[=build_dependency_graph]{build_dependency_graph()}}.}

\item{fields_df}{Optional data frame with a \code{name} column to mark calculated
outputs.}

\item{seed}{Optional integer seed to make the layout reproducible. If \code{NULL}
(default), the function will not alter the caller's RNG state.}
}
\value{
Invisibly returns \code{g}.
}
\description{
Draws a quick base-graphics plot of a dependency graph. Vertices that are
calculated fields (present in \code{fields_df$name}) are drawn differently.
}
\examples{
fields <- tibble::tibble(
name = c("X_plus_Y", "Z"),
formula = c("[X] + [Y]", "[X_plus_Y] * 2")
)
g <- build_dependency_graph(fields)
plot_dependency_graph(g, fields)           # nondeterministic layout
plot_dependency_graph(g, fields, seed = 1) # deterministic layout

}
