% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_linpred.R
\name{posterior_linpred,ubmsFit-method}
\alias{posterior_linpred,ubmsFit-method}
\alias{posterior_linpred}
\title{Posterior Distribution of the Linear Predictor}
\usage{
\S4method{posterior_linpred}{ubmsFit}(
  object,
  transform = FALSE,
  submodel,
  newdata = NULL,
  draws = NULL,
  re.form = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted model of class \code{ubmsFit}}

\item{transform}{Should the linear predictor be transformed using the
inverse link function?}

\item{submodel}{The name of the submodel, as a character string, for
which to calculate the linear predictor}

\item{newdata}{Optional data frame of newdata to use when calculating the linear
predictor. If not provided, the model matrix is used.}

\item{draws}{An integer indicating the number of draws to return. The
default and maximum number of draws is the size of the posterior sample.}

\item{re.form}{If \code{NULL}, any estimated group-level parameters ("random
effects") are included. If \code{NA}, they are ignored}

\item{...}{Currently ignored}
}
\value{
A matrix of simulations from the posterior predictive distribution
 of the linear predictor. The dimensions are \code{draws} by number of
 linear predictor values (e.g., number of sites or number of observations).
}
\description{
Extract posterior draws of the linear predictor for a \code{ubmsFit}
submodel, possibly transformed by the inverse-link function.
}
