% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Auckland.R
\docType{data}
\name{auckland_2}
\alias{auckland_2}
\title{Faculty web colours of the University of Auckland, NZ}
\format{
An object of class \code{character} of length 10.
}
\source{
Color definitions are based on Version 12 of the \href{https://www.auckland.ac.nz/en.html}{University of Auckland}'s 
\href{https://cdn.auckland.ac.nz/assets/central/about/the-university/how-the-university-works/policy-and-administration/web-style-guide.pdf}{Web Style Guide (PDF)}.
}
\usage{
auckland_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{auckland_1} provides the university web colour styles  
of the \href{https://www.auckland.ac.nz/en.html}{University of Auckland}, New Zealand.
}
\details{
The spectrum provides each faculty with the opportunity to have a unique visual identity. 
It has been specifically designed to be web-friendly and match the faculty’s printed collateral  
(e.g., prospectuses).

These colour styles are used as the theme of the faculty site and 
also applies to the link and button styles / gradients.

The documented HEX values should be used for all screen colour representations, 
rather than RGB conversions of the specified print colours.

In addition to these specifications, the website uses a range of 
colours within the spectrum of the colour style.

A faculty is able to choose between using the 
University web colour range (see \code{\link{auckland_1}}) 
or their specific faculty style.
}
\examples{
auckland_2
unikn::seecol(auckland_2, main = "Faculty web colour styles of the University of Auckland, NZ")

}
\seealso{
\code{\link{auckland_1}} for university colours of the University of Auckland;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other New Zealand university color palettes: 
\code{\link{auckland_1}},
\code{\link{otago}},
\code{\link{waikato}}
}
\author{
\strong{unicol}, 2023-09-07.
}
\concept{New Zealand university color palettes}
\keyword{datasets}
