% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Galway.R
\docType{data}
\name{galway_1}
\alias{galway_1}
\title{Primary colors of the University of Galway, Ireland}
\format{
An object of class \code{character} of length 5.
}
\source{
Colour definitions are based on \href{https://www.universityofgalway.ie}{UGalway}'s 
\href{https://www.universityofgalway.ie/media/brand/11901_University_of_Galway_Brand_Guidelines_v13.pdf}{brand guidelines} (PDF).
}
\usage{
galway_1
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{galway_1} provides the five primary colors
of the \href{https://www.universityofgalway.ie}{University of Galway}, Ireland.
}
\details{
The 5 primary colors are
\code{"Galway maroon"} (defined as HEX #a80050), 
\code{"Galway deep maroon"} (defined as HEX #84003d), 
\code{"Galway magenta"} (defined as HEX #e6007e), 
\code{"black"} (defined as HEX #000000), and 
\code{"white"} (defined as HEX #ffffff). 

\code{galway_1} uses the HEX color definitions.
}
\examples{
galway_1
unikn::seecol(galway_1, col_bg = "grey90", 
              main = "Primary colors of the University of Galway")  # view palette

}
\seealso{
\code{\link{galway_2}} for secondary colors of the University of Galway;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Irish university color palettes: 
\code{\link{galway_2}},
\code{\link{limerick_1}},
\code{\link{limerick_2}},
\code{\link{maynooth}},
\code{\link{trinity_1}},
\code{\link{trinity_2}},
\code{\link{ucc_1}},
\code{\link{ucc_2}},
\code{\link{ucd}}
}
\author{
\strong{unicol}, 2023-07-16.
}
\concept{Irish university color palettes}
\keyword{datasets}
