% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UWaterloo.R
\docType{data}
\name{uwaterloo_arts}
\alias{uwaterloo_arts}
\title{Faculty of Arts colors of the University of Waterloo, Canada}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on the University of Waterloo's 
\href{https://uwaterloo.ca/}{Brand home}.
}
\usage{
uwaterloo_arts
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uwaterloo_arts} provides the four orange color levels
of the \href{https://uwaterloo.ca}{University of Waterloo}, Canada.
}
\details{
Use the colour Orange to identify content and communications from the Faculty of Arts.
In order to meet AODA color contrast requirements, there is a digital variation for level 4 orange

The 4 orange colors are 
\code{"Orange Level 1"} (defined as CMYK: 0 12 32 0, RGB: 255 213 165, HEX: #FFD5A5),
\code{"Orange Level 2"} (defined as CMYK: 0 30 99 0, RGB: 251 175 0, HEX: #FBAF00),
\code{"Orange Level 3"} (print primary color) (defined as CMYK: 0 52 100 0, RGB:	231 129 0, HEX:	#E78100), and
\code{"Orange Level 4"} (digital primary color) (defined as RGB: 217 63 0, Hex: #D93F00).

\code{uwaterloo_arts} uses the HEX color definitions.
}
\examples{
uwaterloo_arts
unikn::seecol(uwaterloo_arts, main = "Art faculty colors of UWaterloo") 
# view color palette

}
\seealso{
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-29.
}
\concept{Canadian university color palettes}
\keyword{datasets}
