% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_needed_to_vaccinate.R
\name{compute_number_needed_to_vaccinate_machado}
\alias{compute_number_needed_to_vaccinate_machado}
\title{Compute the number of individuals needed to vaccinate to prevent
one event according to Machado et al. method}
\usage{
compute_number_needed_to_vaccinate_machado(
  number_of_events,
  number_of_events_averted,
  population_size,
  vaccine_effectiveness
)
}
\arguments{
\item{number_of_events}{number of events}

\item{number_of_events_averted}{number of events averted}

\item{population_size}{population size}

\item{vaccine_effectiveness}{vaccine effectiveness}
}
\value{
The number of individuals needed to vaccinate to avert
one event
}
\description{
Compute the number of individuals needed to vaccinate to prevent
one event according to Machado et al. method
}
\details{
The number of individuals needed to vaccinate to prevent one event is calculated as described by Machado et al. (2019) \url{doi:10.2807/1560-7917.ES.2019.24.45.1900268}.
}
\examples{
data(coverage_and_incidence_mock_data)
data(ve_mock_data)
coverage <- coverage_and_incidence_mock_data$coverage_data
incidence <- coverage_and_incidence_mock_data$incidence_data
vaccine_effectiveness <- ve_mock_data$ve
nae <- compute_events_averted_by_vaccination(
  number_of_events = incidence$events,
  cumulative_coverage = coverage$cumulative_coverage,
  vaccine_effectiveness = vaccine_effectiveness
)
nnv_machado <- compute_number_needed_to_vaccinate_machado(
  number_of_events = incidence$events,
  number_of_events_averted = nae,
  population_size = 1234,
  vaccine_effectiveness = vaccine_effectiveness
)
nnv_machado
}
