% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdmx.R
\name{validator_from_dsd}
\alias{validator_from_dsd}
\title{Extract a rule set from an SDMX DSD file}
\usage{
validator_from_dsd(endpoint, agency_id, resource_id, version = "latest")
}
\arguments{
\item{endpoint}{\code{[character]} REST API endpoint of the SDMX registry}

\item{agency_id}{\code{[character]} Agency ID (e.g. \code{"ESTAT"})}

\item{resource_id}{\code{[character]} Resource ID (e.g. \code{"CL_ACTIVITY"})}

\item{version}{\code{[character]} Version of the code list.}
}
\value{
An object of class \code{\link{validator}}.
}
\description{
Data Structure Definitions contain references to code lists.
This function extracts those references and generates rules
that check data against code lists in an SDMX registry.
}
\seealso{
Other sdmx: 
\code{\link{sdmx_codelist}()},
\code{\link{sdmx_endpoint}()}
}
\concept{sdmx}
