% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.stdmean.ps}
\alias{replicate.stdmean.ps}
\title{Compares and combines paired-samples standardized mean differences in original and
follow-up studies}
\usage{
replicate.stdmean.ps(
  alpha,
  m11,
  m12,
  sd11,
  sd12,
  cor1,
  n1,
  m21,
  m22,
  sd21,
  sd22,
  cor2,
  n2,
  stdzr
)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m11}{estimated mean for group 1 in original study}

\item{m12}{estimated mean for group 2 in original study}

\item{sd11}{estimated SD for group 1 in original study}

\item{sd12}{estimated SD for group 2 in original study}

\item{cor1}{estimated correlation of paired observations in orginal study}

\item{n1}{sample size in original study}

\item{m21}{estimated mean for group 1 in follow-up study}

\item{m22}{estimated mean for group 2 in follow-up study}

\item{sd21}{estimated SD for group 1 in follow-up study}

\item{sd22}{estimated SD for group 2 in follow-up study}

\item{cor2}{estimated correlation of paired observations in follow-up study}

\item{n2}{sample size in follow-up study}

\item{stdzr}{\itemize{
\item set to 0 for square root unweighted average variance standardizer
\item set to 1 for measurement 1 SD standardizer
\item set to 2 for measurement 2 SD standardizer
}}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the original study
\item Row 2 summarizes the follow-up study
\item Row 3 estimates the difference in standardized mean differences
\item Row 4 estimates the average standardized mean difference
}

The columns are:
\itemize{
\item Estimate - standardized mean difference estimate (single study, difference, average)
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function computes confidence intervals from an original study and a follow-up
study where the effect size is a paired-samples standardized mean difference.
Confidence intervals for the difference and average effect size are also computed.
Equality of variances within or across studies is not assumed. The confidence level
for the difference is 1 – 2*alpha, which is recommended for equivalence testing.
Square root unweighted variances and single-condition standard deviation are options
for the standardizer.
}
\examples{
replicate.stdmean.ps(alpha = .05, 86.22, 70.93, 14.89, 12.32, .765, 20, 
                                  84.81, 77.24, 15.68, 16.95, .702, 75, 0)

# Should return:
#                         Estimate         SE        LL        UL
#  Orginal:              1.0890300 0.22915553 0.6697353 1.5680085
#  Follow-up:            0.4604958 0.09590506 0.2756687 0.6516096
#  Original - Follow-up: 0.6552328 0.24841505 0.2466264 1.0638392
#  Average:              0.7747629 0.12420752 0.5313206 1.0182052


}
\references{
\insertRef{Bonett2021}{vcmeta}
}
