% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareSimulations.R
\name{compareSimulations}
\alias{compareSimulations}
\title{Compares different simulations produced by \code{\link{simulatePopulation}}.}
\usage{
compareSimulations(
  simulation.output = NULL,
  species = "all",
  filename = NULL,
  columns = "Pollen",
  time.zoom = NULL,
  width = 12,
  text.size = 20,
  title.size = 25,
  plot.title = ""
  )
}
\arguments{
\item{simulation.output}{list, output of \code{\link{simulatePopulation}}.}

\item{species}{a number or vector or numbers representing rows in the parameters dataframe, or a string or vector of strings referencing to the "label" column of the parameters dataframe.}

\item{filename}{character string, name of output pdf file. If NULL or empty, no pdf is produced.}

\item{columns}{character string or vector of character strings with these possible values: "Pollen", "Population.mature", "Population.immature", "Population.viable.seeds", "Suitability", "Biomass.total", "Biomass.mature", "Biomass.immature", "Mortality.mature", "Mortality.immature", "Driver.A", "Driver.B".}

\item{time.zoom}{vector of two numbers, indicating the beginnign and end of the time interval to be plotted (i.e. "c(5000, 10000)")}

\item{width}{plot width in inches.}

\item{text.size}{text size of the plot.}

\item{title.size}{plot title size.}

\item{plot.title}{character string to use as plot title.}
}
\description{
Plots together the results of different virtual taxa produced by a single run of \code{\link{simulatePopulation}}.
}
\details{
The user can decide what virtual taxa to plot through the \code{species} argument, and what information to show throught the \code{columns} argument. Output is plotted on screen by default, and printed to pdf if the \code{filename} argument is filled.
}
\examples{

#getting example data
data(simulation)

#compare taxa 1, 2, and 3.
compareSimulations(simulation.output = simulation,
 species = c(1, 2, 3),
 columns = c("Pollen", "Suitability"),
 time.zoom = c(1000, 2000)
)

}
\seealso{
\code{\link{simulatePopulation}}, \code{\link{plotSimulation}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
