% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visTree.R
\name{visTree}
\alias{visTree}
\title{Visualize Recursive Partitioning and Regression Trees (rpart object)}
\usage{
visTree(
  object,
  data = NULL,
  tooltipColumns = if (!is.null(data)) {
     1:ncol(data)
 } else {
     NULL
 },
  main = "",
  submain = "",
  footer = "",
  direction = "UD",
  fallenLeaves = FALSE,
  rules = TRUE,
  simplifyRules = TRUE,
  shapeVar = "dot",
  shapeY = "square",
  colorVar = NULL,
  colorY = NULL,
  colorEdges = "#8181F7",
  nodesFontSize = 16,
  edgesFontSize = 14,
  edgesFontAlign = "horizontal",
  legend = TRUE,
  legendNodesSize = 22,
  legendFontSize = 16,
  legendWidth = 0.1,
  legendNcol = 1,
  legendPosition = "left",
  nodesPopSize = FALSE,
  minNodeSize = 15,
  maxNodeSize = 30,
  highlightNearest = list(enabled = TRUE, degree = list(from = 50000, to = 0), hover =
    FALSE, algorithm = "hierarchical"),
  collapse = list(enabled = TRUE, fit = TRUE, resetHighlight = TRUE, clusterOptions =
    list(fixed = TRUE, physics = FALSE)),
  updateShape = TRUE,
  tooltipDelay = 500,
  digits = 3,
  height = "600px",
  width = "100\%",
  export = TRUE
)
}
\arguments{
\item{object}{\code{rpart}, rpart object}

\item{data}{\code{data.frame}, adding mini-graphics in tooltips using \code{sparkline} and \code{tooltipColumns} ?}

\item{tooltipColumns}{\code{numeric}, indice of columns used in tooltip. All by default.
So, we add boxplot / pie focus on sub-population vs all population using \code{sparkline} package. \code{NULL} to disable.}

\item{main}{Title. See  \link[visNetwork]{visNetwork}}

\item{submain}{Subtitle. See  \link[visNetwork]{visNetwork}}

\item{footer}{Footer. See  \link[visNetwork]{visNetwork}}

\item{direction}{\code{character}, The direction of the hierarchical layout.
The available options are: UD, DU, LR, RL. To simplify:
up-down, down-up, left-right, right-left. Default UD. See  \link[visNetwork]{visHierarchicalLayout}}

\item{fallenLeaves}{\code{boolean} leaf nodes at the bottom of the graph ? Default to FALSE}

\item{rules}{\code{boolean}, add rules in tooltips ? Default to TRUE}

\item{simplifyRules}{\code{boolean}, simplify rules writing}

\item{shapeVar}{\code{character}, shape for variables nodes See  \link[visNetwork]{visNodes}}

\item{shapeY}{\code{character}, shape for terminal nodes See  \link[visNetwork]{visNodes}}

\item{colorVar}{\code{character}, colors to use or \code{data.frame} To set color of variables. 2 columns :
\itemize{
  \item "variable" names of variables
  \item "color" colors (in hexa). See examples
}}

\item{colorY}{if classification tree : \code{character} colors to use or \code{data.frame} 2 columns :
\itemize{
  \item "modality" levels of Y
  \item "color" colors (in hexa)
}
if regression tree : \code{character}, 2 colors (min and max, in hexa)}

\item{colorEdges}{\code{character}, color of edges, in hexa. Default to #8181F7}

\item{nodesFontSize}{\code{numeric}, size of labels of nodes. Default to 16}

\item{edgesFontSize}{\code{numeric}, size of labels of edges Default to 14}

\item{edgesFontAlign}{\code{character}, for edges only. Default tp 'horizontal'. Possible options: 'horizontal' (Default),'top','middle','bottom'. See  \link[visNetwork]{visEdges}}

\item{legend}{\code{boolean}, add legend ? Default TRUE.  \link[visNetwork]{visLegend}}

\item{legendNodesSize}{\code{numeric}, size of nodes in legend. Default to 22}

\item{legendFontSize}{\code{numeric}, size of labels of nodes in legend. Default to 16}

\item{legendWidth}{\code{numeric}, legend width, between 0 and 1. Default 0.1}

\item{legendNcol}{\code{numeric}, number of columns in legend. Default 1}

\item{legendPosition}{\code{character}, one of "left" (Default) or "right"}

\item{nodesPopSize}{\code{boolean}, nodes sizes depends on population ? Default to FALSE}

\item{minNodeSize}{\code{numeric}, in case of \code{nodesPopSize}, minimum size of a node. Default to 15. Else, nodes size is minNodeSize + maxNodeSize / 2}

\item{maxNodeSize}{\code{numeric}, in case of \code{nodesPopSize}, maximum size of a node. Default to 30. Else, nodes size is minNodeSize + maxNodeSize / 2}

\item{highlightNearest}{\code{list}, Highlight nearest nodes. See  \link[visNetwork]{visOptions}}

\item{collapse}{\code{list}, collapse or not using double click on a node ? See  \link[visNetwork]{visOptions}}

\item{updateShape}{\code{boolean}, in case of collapse, udpate cluster node shape as terminal node ? Default to TRUE}

\item{tooltipDelay}{\code{numeric}, delay for tooltips in millisecond. Default 500}

\item{digits}{\code{numeric}, number of digits. Default to 3}

\item{height}{\code{character}, default to "600px"}

\item{width}{\code{character}, default to "100\%"}

\item{export}{\code{boolean}, add export button. Default to TRUE}
}
\value{
a visNetwork object
}
\description{
Visualize Recursive Partitioning and Regression Trees \code{rpart}. Have a look to  \link[visNetwork]{visTreeEditor} to edity and get back network, or to  \link[visNetwork]{visTreeModuleServer} to use custom tree module in R
}
\examples{

\dontrun{

library(rpart)

# Basic classification tree
res <- rpart(Species~., data=iris)
visTree(res, data = iris, main = "Iris classification Tree")

# Basic regression tree
res <- rpart(Petal.Length~., data=iris)
visTree(res, edgesFontSize = 14, nodesFontSize = 16)

# Complex tree
data("solder")
res <- rpart(Opening~., data = solder, control = rpart.control(cp = 0.00005))
visTree(res, data = solder, nodesPopSize = TRUE, minNodeSize = 10, 
  maxNodeSize = 30, height = "800px")

# ----- Options
res <- rpart(Opening~., data = solder, control = rpart.control(cp = 0.005))

# fallen leaves + align edges label & size
visTree(res, fallenLeaves = TRUE, height = "500px", 
 edgesFontAlign = "middle", edgesFontSize = 20)

# disable rules in tooltip, and render tooltip faster
# enable hover highlight
visTree(res, rules = FALSE, tooltipDelay = 0, 
 highlightNearest = list(enabled = TRUE, degree = list(from = 50000, to = 0), 
 hover = TRUE, algorithm = "hierarchical"))

# Change color with data.frame
colorVar <- data.frame(variable = names(solder), 
 color = c("#339933", "#b30000","#4747d1","#88cc00", "#9900ff","#247856"))
 
colorY <- data.frame(modality = unique(solder$Opening), 
 color = c("#AA00AA", "#CDAD15", "#213478"))

visTree(res, colorEdges = "#000099", colorVar = colorVar, colorY = colorY)

# Change color with vector
visTree(res, colorEdges = "#000099", 
    colorVar = substring(rainbow(6), 1, 7), 
    colorY = c("blue", "green", "orange"))
    
    
 # Use visNetwork functions to add more options
visTree(res) \%>\% 
    visOptions(highlightNearest = TRUE)


}

}
\references{
See online documentation \url{https://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link[visNetwork]{visTreeEditor},  \link[visNetwork]{visTreeModuleServer},  \link[visNetwork]{visNetworkEditor}
}
