% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset.visreg}
\alias{subset.visreg}
\title{Subset a visreg object}
\usage{
\method{subset}{visreg}(x, sub, ...)
}
\arguments{
\item{x}{A \code{visreg} object.}

\item{sub}{Logical expression indicating elements to keep, as in \code{\link[=subset]{subset()}}}

\item{...}{Not used.}
}
\description{
Subset a visreg object so that only a portion of the full model is plotted.
}
\examples{
# Fit a model and construct a visreg object
airquality$Heat <- cut(airquality$Temp,3,labels=c("Cool","Mild","Hot"))
fit <- lm(Ozone~ Solar.R + Wind*Heat,data=airquality)
v <- visreg(fit, "Wind", by="Heat", plot=FALSE)

# Plot only certain levels
vv <- subset(v, Heat \%in\% c("Cool", "Hot"))
plot(vv)

# Plot only up to wind 15 mph
vv <- subset(v, Wind < 15)
plot(vv)
}
