% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/garcon.R
\name{garcon}
\alias{garcon}
\alias{useGarcon}
\alias{use_garcon}
\alias{Garcon}
\title{Garcon}
\usage{
useGarcon()

use_garcon()
}
\description{
Create a garcon to animate images on the waiter.
}
\examples{

## ------------------------------------------------
## Method `Garcon$new`
## ------------------------------------------------

\dontrun{Garcon$new("img")$set(30)}

## ------------------------------------------------
## Method `Garcon$set`
## ------------------------------------------------

\dontrun{Garcon$new("img")$set(30)}

## ------------------------------------------------
## Method `Garcon$inc`
## ------------------------------------------------

\dontrun{Garcon$new("img")$inc(30)}

## ------------------------------------------------
## Method `Garcon$reset`
## ------------------------------------------------

\dontrun{Garcon$new("img")$set(30)$reset()}

## ------------------------------------------------
## Method `Garcon$destroy`
## ------------------------------------------------

\dontrun{Garcon$new("img")$set(30)$destroy()}

## ------------------------------------------------
## Method `Garcon$close`
## ------------------------------------------------

\dontrun{Garcon$new("img")$set(30)$close()}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Garcon-new}{\code{Garcon$new()}}
\item \href{#method-Garcon-set}{\code{Garcon$set()}}
\item \href{#method-Garcon-inc}{\code{Garcon$inc()}}
\item \href{#method-Garcon-reset}{\code{Garcon$reset()}}
\item \href{#method-Garcon-destroy}{\code{Garcon$destroy()}}
\item \href{#method-Garcon-print}{\code{Garcon$print()}}
\item \href{#method-Garcon-close}{\code{Garcon$close()}}
\item \href{#method-Garcon-clone}{\code{Garcon$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Garcon-new"></a>}}
\if{latex}{\out{\hypertarget{method-Garcon-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$new(
  image,
  bg_color = "#FFFFFF",
  opacity = 0.5,
  direction = c("bt", "tb", "lr", "rl"),
  filter = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{image}}{The CSS id of the image tag.}

\item{\code{bg_color}}{Background overlay color in hexadecimal or RGB.}

\item{\code{opacity}}{Overlay transparency.}

\item{\code{direction}}{Animation direction. Possible values: `lr` (left to right), 
`rl` (right to left), `bt` (bottom to top), `tb` (top to bottom).}

\item{\code{filter}}{Filter to apply, options are `blur`, `grayscale`, `sepia`, 
`hue-rotate`, `invert`, `opacity`.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialise the garçon.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$set(30)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Garcon-set"></a>}}
\if{latex}{\out{\hypertarget{method-Garcon-set}{}}}
\subsection{Method \code{set()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$set(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Percentage to set to.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Value to set the garçon to.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$set(30)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Garcon-inc"></a>}}
\if{latex}{\out{\hypertarget{method-Garcon-inc}{}}}
\subsection{Method \code{inc()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$inc(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Percentage to increase to.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Value to increase the garçon to.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$inc(30)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Garcon-reset"></a>}}
\if{latex}{\out{\hypertarget{method-Garcon-reset}{}}}
\subsection{Method \code{reset()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$reset(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Percentage to set to.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Reset the garçon to.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$set(30)$reset()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Garcon-destroy"></a>}}
\if{latex}{\out{\hypertarget{method-Garcon-destroy}{}}}
\subsection{Method \code{destroy()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$destroy()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Kill the garçon to.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$set(30)$destroy()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Garcon-print"></a>}}
\if{latex}{\out{\hypertarget{method-Garcon-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
print the garcon
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Garcon-close"></a>}}
\if{latex}{\out{\hypertarget{method-Garcon-close}{}}}
\subsection{Method \code{close()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$close()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Close the garçon.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$set(30)$close()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Garcon-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Garcon-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
