% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{store_yaml}
\alias{store_yaml}
\title{Store a list as YAML in a workspace}
\usage{
store_yaml(
  x,
  list,
  filename,
  name = NULL,
  subdir,
  timestamp = format(Sys.time(), "\%Y-\%m-\%d \%H:\%M:\%S")
)
}
\arguments{
\item{x}{The workspace object.}

\item{list}{The R list object to save as YAML in the workspace.}

\item{filename}{The name of the file used to store the YAML file in the workspace.}

\item{name}{name associated with the object, if a workspace file with this name exists
already it will be replaced.}

\item{subdir}{A subdirectory within the asset directory where the YAML file will be stored.}

\item{timestamp}{A timestamp string to associate with the entry in the workspace.}
}
\value{
Returns the \link{workspace} object passed to \code{x} parameter. Called primarily for side effects.
}
\description{
Saves a list object as a YAML file in an existing workspace.

This function allows users to save R list objects as YAML files into a specified workspace.
The file is saved under the provided filename and can be organized within
a specific subdirectory for better management.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)

config_list <- list(
  database = list(
    host = "localhost",
    port = 5432,
    name = "mydb"
  ),
  settings = list(
    debug = TRUE,
    max_connections = 100
  )
)
z <- store_yaml(
  x = z,
  list = config_list,
  filename = "config.yaml",
  timestamp = "2023-11-12 11:37:41",
  subdir = "configs"
)
z
}
\seealso{
\link{workspace} for package documentation

Other functions to write in a workspace: 
\code{\link{delete_dataset}()},
\code{\link{store_dataset}()},
\code{\link{store_json}()},
\code{\link{store_raster}()},
\code{\link{store_rds}()}
}
\concept{functions to write in a workspace}
