% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache}
\alias{cache}
\alias{wb_cache_dir}
\alias{wb_cache_delete}
\title{Get or manage the worldbank API cache}
\usage{
wb_cache_dir()

wb_cache_delete()
}
\description{
\code{wb_cache_dir()} returns the path where cached API responses are stored.
\code{wb_cache_delete()} clears all cached responses.
}
\details{
The cache is only used when enabled with \code{options(worldbank.cache = TRUE)}.
Cached responses are stored for 1 day by default, but this can be customized with
\code{options(worldbank.cache_max_age = seconds)}.
}
\examples{
\dontrun{
# enable caching
options(worldbank.cache = TRUE)

# view cache location
wb_cache_dir()

# clear the cache
wb_cache_delete()
}
}
