% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foldChangeArrow2.R
\name{foldChangeArrow2}
\alias{foldChangeArrow2}
\title{Add arrow for expected Fold-Change to VolcanoPlot or MA-plot}
\usage{
foldChangeArrow2(
  FC,
  useComp = 1,
  isLin = TRUE,
  asX = TRUE,
  col = 1,
  arr = c(0.005, 0.15),
  lwd = NULL,
  addText = c(line = -0.9, cex = 0.7, txt = "expected", loc = "toright"),
  returnRatio = FALSE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{FC}{(numeric, list or MArrayLM-object) main information for drawing arrow : either numeric value for fold-change/log2-ratio of object to search for colnames of statistical testing for extracting numeric part}

\item{useComp}{(integer) only used in case FC is list or MArrayLM-object an has multiple pairwise-comparisons}

\item{isLin}{(logical) inidicate if \code{FC} is log2 or not}

\item{asX}{(logical) indicate if arrow should be on x-axis}

\item{col}{(integer or character) custom color}

\item{arr}{(numeric, length=2) start- and end-points of arrow (as relative to entire plot)}

\item{lwd}{(numeric) line-width of arrow}

\item{addText}{(logical or named vector) indicate if text explaining arrow should be displayed, use \code{TRUE} for default (on top right of plot), 
or any combination of 'loc','line','cex','side','adj','col','text' (or 'txt') for customizing specific elements}

\item{returnRatio}{(logical) return ratio}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) display additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
plots arrow only (and explicative text), if \code{returnRatio=TRUE} also returns numeric value for extracted ratio
}
\description{
NOTE : This function is deprecated, please use \code{\link[wrGraph]{foldChangeArrow}} instead !!
This function was made for adding an arrow indicating a fold-change to MA- or Volcano-plots. 
When comparing mutiple concentratios of standards in benchmark-tests it may be useful to indicate the expected ratio in a pair-wise comparison.
In case of main input as list or MArrayLM-object (as generated from limma), the colum-names of multiple pairwise comparisons can be used 
for extracting a numeric content (supposed as concentrations in sample-names) which will be used to determine the expected ratio used for plotting. 
Optionally the ratio used for plotting can be returned as numeric value.
}
\details{
The argument \code{addText} also allows specifying a fixed position when using \code{addText=c(loc="bottomleft")}, also bottomright, topleft, topright, toleft and toright may be used.
  In this case the elemts \code{side} and \code{adjust} will be redefined to accomodate the text in the corner specified. 

 Ultimately this function will be integated to the package wrGraph.
}
\examples{
plot(rnorm(20,1.5,0.1),1:20)
#deprecated# foldChangeArrow2(FC=1.5) 

}
\seealso{
new version : \code{\link[wrGraph]{foldChangeArrow}}; used with \code{\link[wrGraph]{MAplotW}}, \code{\link[wrGraph]{VolcanoPlotW}}
}
