% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.R
\name{set_dv_probs}
\alias{set_dv_probs}
\title{Set probability columns for categorical endpoints}
\usage{
set_dv_probs(
  xpdb,
  .problem = NULL,
  ...,
  .dv_var = NULL,
  .handle_missing = c("quiet", "warn", "error")
)
}
\arguments{
\item{xpdb}{<\code{xp_xtras}> object}

\item{.problem}{<\code{numeric}> Problem number to use. Uses the all problems if \code{NULL}}

\item{...}{Formulas where LHS are levels or pseudo-functions (see Details), and RHS
are columns with probabilities of those levels.}

\item{.dv_var}{<\code{tidyselect}> of column having the categorical observation. Default is first-listed
\code{catdv}.}

\item{.handle_missing}{<\code{character}> How to handle missing levels: "quiet", "warn", or "error"}
}
\value{
<\code{xp_xtras}> object with updated probabilities
}
\description{
For categorical DVs or similar endpoints (such as censoring
flag columns, like \code{BLQ}), this function allows probability
columns to be defined for each level.
}
\details{
The same probability cannot be assigned to multiple values. Pseudo-functions can be used, or
new columns can be created to overcome this limitation. The available pseudo-functions should
be written like \code{ge(value)} (for \code{>=}), \code{gt(value)} (for \code{>}), etc. These comparison names
are those used in Perl, Fortran and many other languages. The function \code{eq()} should not be used,
but it will be ignored either way; equivalence is implied with the base syntax.
}
\examples{
pkpd_m3 \%>\%
 # Not necessary, but correct to set var type before using this
 set_var_types(.problem=1, catdv=BLQ, dvprobs=LIKE) \%>\%
 # Set var type. Warnings can be helpful unless an inverse likelihood column is available
 set_dv_probs(.problem=1, 1~LIKE, .dv_var = BLQ, .handle_missing = "warn") \%>\%
 list_vars()

# Same as above with demo of inverse column
pkpd_m3 \%>\%
 xpose::mutate(INVLIKE = 1-LIKE) \%>\%
 set_var_types(.problem=1, catdv=BLQ, dvprobs=c(LIKE,INVLIKE)) \%>\%
 # Note no warning
 set_dv_probs(.problem=1, 1~LIKE, 0~INVLIKE, .dv_var = BLQ, .handle_missing = "warn")\%>\%
 list_vars()

# With categorical model
vismo_pomod  \%>\%
 # Update var types
 set_var_types(.problem=1, catdv=DV, dvprobs=matches("^P\\\\d+$")) \%>\%
 # Warning (as noted), does not recognize 3 is covered implicitly. That's ok!
 set_dv_probs(.problem=1, 0~P0,1~P1,ge(2)~P23, .handle_missing = "warn")\%>\%
 list_vars()

# Same as above, but...
vismo_pomod  \%>\%
 set_var_types(.problem=1, catdv=DV, dvprobs=matches("^P\\\\d+$")) \%>\%
 # Default is to not bother users with a warning
 set_dv_probs(.problem=1, 0~P0,1~P1,ge(2)~P23)\%>\%
 list_vars()

}
